/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.config;

import de.lwsystems.mailarchive.bennoimport.core.utils.ParseYamlUtils;
import de.lwsystems.mailarchive.bennoimport.smtp.config.Benno;
import de.lwsystems.mailarchive.bennoimport.smtp.config.Configuration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class ConfigurationHandler {
    private static ConfigurationHandler configHandler;
    private final Configuration configuration;

    private ConfigurationHandler(Path configPath) throws IOException {
        this.configuration = ConfigurationHandler.loadConfig(configPath);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public static ConfigurationHandler getInstance() throws FileNotFoundException {
        if (configHandler == null) {
            throw new FileNotFoundException("Configuration file not found or not correctly loaded.");
        }
        return configHandler;
    }

    public static ConfigurationHandler getInstance(Path configPath) throws IOException {
        if (configHandler == null) {
            configHandler = new ConfigurationHandler(configPath);
        }
        return configHandler;
    }

    public static Benno getBenno() throws FileNotFoundException {
        return ConfigurationHandler.getInstance().getConfig().getBenno();
    }

    private static Configuration loadConfig(Path configPath) throws IOException {
        return (Configuration)ParseYamlUtils.parseYamlContent((String)Files.readString(configPath), Configuration.class);
    }

    public static void unsetInstance() {
        if (configHandler != null) {
            configHandler = null;
        }
    }
}

