/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.smtp;

import de.lwsystems.mailarchive.bennoimport.core.config.yaml.httpclient.HttpClient;
import de.lwsystems.mailarchive.bennoimport.core.services.CalculateChecksumService;
import de.lwsystems.mailarchive.bennoimport.core.services.DirectoryHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.FileHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.ICalculateChecksum;
import de.lwsystems.mailarchive.bennoimport.core.services.IDirectoryHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.IFileHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailDelete;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailValidation;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailWrite;
import de.lwsystems.mailarchive.bennoimport.core.services.IProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.IStreamReader;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.MailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.MailDelete;
import de.lwsystems.mailarchive.bennoimport.core.services.MailStreamReader;
import de.lwsystems.mailarchive.bennoimport.core.services.MailValidationService;
import de.lwsystems.mailarchive.bennoimport.core.services.MailWrite;
import de.lwsystems.mailarchive.bennoimport.core.services.ProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.TempFileHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.BennoMailEnvelopeGenerator;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IEnvelopeGenerator;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailConverter;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IMicrosoftJournalMailParserFactory;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IStreamCombiner;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.MicrosoftJournalMail;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.MicrosoftJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.MicrosoftJournalMailTextParserFactory;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.SequenceInputStreamCombiner;
import de.lwsystems.mailarchive.bennoimport.smtp.config.ConfigurationHandler;
import de.lwsystems.mailarchive.bennoimport.smtp.smtp.SMTPMailServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.subethamail.smtp.server.SMTPServer;

public class SMTPServerBuilder {
    private static final Logger LOGGER = LogManager.getLogger(SMTPServerBuilder.class);
    private String configPath;

    public SMTPServerBuilder withConfigPath(String configPath) {
        this.configPath = configPath;
        return this;
    }

    public SMTPServer build() throws IOException {
        if (this.configPath == null) {
            LOGGER.error("No configuration file was set");
            throw new IllegalArgumentException("No configuration file was set");
        }
        LOGGER.debug("Load configuration file from {}", (Object)this.configPath);
        ConfigurationHandler.getInstance(Paths.get(this.configPath, new String[0]).toAbsolutePath());
        ITempFileHandling tempFileHandling = SMTPServerBuilder.createTempFileHandling();
        return SMTPServerBuilder.createSmtpServer(tempFileHandling);
    }

    private static ITempFileHandling createTempFileHandling() throws FileNotFoundException {
        MailDelete mailDelete = new MailDelete();
        MailWrite mailWrite = new MailWrite((IMailDelete)mailDelete);
        FileHandler fileHandler = new FileHandler();
        DirectoryHandler directoryHandler = new DirectoryHandler();
        ProcessFile processFile = new ProcessFile((IMailWrite)mailWrite, ConfigurationHandler.getBenno().getSmtp().getContainerBlacklist(), ConfigurationHandler.getBenno().getSmtp().getHeader(), ConfigurationHandler.getBenno().getSmtp().getWaitTime(), true);
        return new TempFileHandlingService((IFileHandler)fileHandler, ConfigurationHandler.getBenno().getTempFiles().getTempFolder(), (IProcessFile)processFile, (IDirectoryHandler)directoryHandler);
    }

    private static SMTPServer createSmtpServer(ITempFileHandling tempFileHandling) throws FileNotFoundException {
        CalculateChecksumService calculateChecksumService = new CalculateChecksumService();
        MailStreamReader streamReader = new MailStreamReader(List.of());
        MailCreator mailCreator = new MailCreator((IStreamReader)streamReader);
        IJournalMailHandlingService journalMailHandlingService = SMTPServerBuilder.createJournalMailHandlingService(tempFileHandling, (IMailCreator)mailCreator, (ICalculateChecksum)calculateChecksumService);
        HttpClient httpClient = ConfigurationHandler.getBenno().getRestEndpoint().getHttpClient();
        return SMTPMailServer.createServer(tempFileHandling, (IMailCreator)mailCreator, (ICalculateChecksum)calculateChecksumService, httpClient, ConfigurationHandler.getBenno(), journalMailHandlingService);
    }

    private static IJournalMailHandlingService createJournalMailHandlingService(ITempFileHandling tempFileHandling, IMailCreator mailCreator, ICalculateChecksum calculateChecksumService) {
        MicrosoftJournalMailTextParserFactory microsoftJournalMailParserFactory = new MicrosoftJournalMailTextParserFactory();
        BennoMailEnvelopeGenerator envelopeGenerator = new BennoMailEnvelopeGenerator();
        SequenceInputStreamCombiner streamCombiner = new SequenceInputStreamCombiner();
        MicrosoftJournalMail converter = new MicrosoftJournalMail((IMicrosoftJournalMailParserFactory)microsoftJournalMailParserFactory, (IEnvelopeGenerator)envelopeGenerator, (IStreamCombiner)streamCombiner);
        MailValidationService mailValidationService = new MailValidationService(mailCreator);
        MicrosoftJournalMailHandlingService journalMailHandlingService = new MicrosoftJournalMailHandlingService((IJournalMailConverter)converter, tempFileHandling, (IMailValidation)mailValidationService, calculateChecksumService);
        return journalMailHandlingService;
    }
}

