#!/bin/sh
# preinst script for benno-import-smtp
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$DAEMON_USER" ] && DAEMON_USER=benno
        [ -z "$DAEMON_GROUP" ] && DAEMON_GROUP=benno
        [ -z "$DAEMON_LIB" ] && DAEMON_LIB=/opt/benno-import
        [ -z "$DAEMON_CONF" ] && DAEMON_CONF=/etc/benno-import
        [ -z "$DAEMON_LOG" ] && DAEMON_LOG=/var/log/benno
        [ -z "$WEBSRV_GROUP" ] && WEBSRV_GROUP=www-data

        if ! getent group | grep -q "^$DAEMON_GROUP:" ; then
            echo -n "Adding group $DAEMON_GROUP.."
            $BENNOGID && [ -z $BENNOGID ] || GARG="--gid $BENNOGID"
            addgroup --quiet --system $DAEMON_GROUP $GARG 2>/dev/null ||true
            echo "..done"
        fi
        if ! getent passwd | grep -q "^$DAEMON_USER:"; then
            echo -n "Adding system user $DAEMON_USER.."
            adduser --quiet --system --ingroup $DAEMON_GROUP \
                --home /opt/benno-import --no-create-home \
                --disabled-password $DAEMON_USER 2>/dev/null || true
            echo "..done"
        fi

        test -d $DAEMON_LIB || mkdir $DAEMON_LIB
        test -d $DAEMON_CONF || mkdir $DAEMON_CONF
        test -d $DAEMON_LOG || mkdir $DAEMON_LOG


        if ! dpkg-statoverride --list $DAEMON_LIB >/dev/null
        then
            chown $DAEMON_USER:$DAEMON_GROUP $DAEMON_LIB
            chmod u=rwx,g=rx,o= $DAEMON_LIB
        fi

        if ! dpkg-statoverride --list $DAEMON_CONF >/dev/null
        then
            chown $DAEMON_USER:$WEBSRV_GROUP $DAEMON_CONF
            chmod u=rwx,g=rx,o= $DAEMON_CONF
        fi

        if ! dpkg-statoverride --list $DAEMON_LOG >/dev/null
        then
            chown $DAEMON_USER:$DAEMON_GROUP $DAEMON_LOG
            chmod u=rwx,g=rx,o= $DAEMON_LOG
        fi
 
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
