#!/bin/sh
# postinst script for benno-kopano-webapp-plugin
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    . /usr/share/debconf/confmodule
    db_get benno-kopano-webapp-plugin/bennopath
    BENNOPATH=$RET
    db_get benno-kopano-webapp-plugin/bennocontainer
    BENNOCONTAINER=$RET

    perl -pi -se 's/^bennopath\s=.*/bennopath = $bennopath/' -- -bennopath="$BENNOPATH" /etc/benno-kopano-webapp-plugin/settings.ini
    perl -pi -se 's/^bennocontainer\s=.*/bennocontainer = $bennocontainer/' -- -bennocontainer="$BENNOCONTAINER" /etc/benno-kopano-webapp-plugin/settings.ini
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
