/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import org.apache.poi.xslf.usermodel.XSLFHyperlink;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextStrikeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;

public class XSLFTextRun {
    private final CTRegularTextRun _r;
    private final XSLFTextParagraph _p;

    XSLFTextRun(CTRegularTextRun r, XSLFTextParagraph p) {
        this._r = r;
        this._p = p;
    }

    XSLFTextParagraph getParentParagraph() {
        return this._p;
    }

    public String getText() {
        return this._r.getT();
    }

    public void setText(String text) {
        this._r.setT(text);
    }

    public CTRegularTextRun getXmlObject() {
        return this._r;
    }

    public void setFontColor(Color color) {
        CTTextCharacterProperties rPr = this.getRpR();
        CTSolidColorFillProperties fill = rPr.isSetSolidFill() ? rPr.getSolidFill() : rPr.addNewSolidFill();
        CTSRgbColor clr = fill.isSetSrgbClr() ? fill.getSrgbClr() : fill.addNewSrgbClr();
        clr.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public void setFontSize(double fontSize) {
        CTTextCharacterProperties rPr = this.getRpR();
        if (fontSize == -1.0) {
            if (rPr.isSetSz()) {
                rPr.unsetSz();
            }
        } else {
            rPr.setSz((int)(100.0 * fontSize));
        }
    }

    public double getFontSize() {
        if (!this._r.isSetRPr() || !this._r.getRPr().isSetSz()) {
            return -1.0;
        }
        return (double)this._r.getRPr().getSz() * 0.01;
    }

    public void setFontFamily(String typeface) {
        this.setFontFamily(typeface, (byte)-1, (byte)-1, false);
    }

    public void setFontFamily(String typeface, byte charset, byte pictAndFamily, boolean isSymbol) {
        CTTextCharacterProperties rPr = this.getRpR();
        if (typeface == null) {
            if (rPr.isSetLatin()) {
                rPr.unsetLatin();
            }
            if (rPr.isSetCs()) {
                rPr.unsetCs();
            }
            if (rPr.isSetSym()) {
                rPr.unsetSym();
            }
        } else if (isSymbol) {
            CTTextFont font = rPr.isSetSym() ? rPr.getSym() : rPr.addNewSym();
            font.setTypeface(typeface);
        } else {
            CTTextFont latin = rPr.isSetLatin() ? rPr.getLatin() : rPr.addNewLatin();
            latin.setTypeface(typeface);
            if (charset != -1) {
                latin.setCharset(charset);
            }
            if (pictAndFamily != -1) {
                latin.setPitchFamily(pictAndFamily);
            }
        }
    }

    public String getFontFamily() {
        if (!this._r.isSetRPr() || !this._r.getRPr().isSetLatin()) {
            return null;
        }
        return this._r.getRPr().getLatin().getTypeface();
    }

    public void setStrikethrough(boolean strike) {
        this.getRpR().setStrike(strike ? STTextStrikeType.SNG_STRIKE : STTextStrikeType.NO_STRIKE);
    }

    public boolean isStrikethrough() {
        if (!this._r.isSetRPr()) {
            return false;
        }
        return this._r.getRPr().getStrike() == STTextStrikeType.SNG_STRIKE;
    }

    public void setBold(boolean bold) {
        this.getRpR().setB(bold);
    }

    public boolean isBold() {
        if (!this._r.isSetRPr()) {
            return false;
        }
        return this._r.getRPr().getB();
    }

    public void setItalic(boolean italic) {
        this.getRpR().setI(italic);
    }

    public boolean isItalic() {
        if (!this._r.isSetRPr()) {
            return false;
        }
        return this._r.getRPr().getI();
    }

    public void setUnderline(boolean underline) {
        this.getRpR().setU(underline ? STTextUnderlineType.SNG : STTextUnderlineType.NONE);
    }

    public boolean isUnderline() {
        if (!this._r.isSetRPr() || !this._r.getRPr().isSetU()) {
            return false;
        }
        return this._r.getRPr().getU() != STTextUnderlineType.NONE;
    }

    protected CTTextCharacterProperties getRpR() {
        return this._r.isSetRPr() ? this._r.getRPr() : this._r.addNewRPr();
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }

    public XSLFHyperlink createHyperlink() {
        XSLFHyperlink link = new XSLFHyperlink(this._r.getRPr().addNewHlinkClick(), this);
        return link;
    }

    public XSLFHyperlink getHyperlink() {
        if (!this._r.getRPr().isSetHlinkClick()) {
            return null;
        }
        return new XSLFHyperlink(this._r.getRPr().getHlinkClick(), this);
    }
}

