/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.DefaultHtmlMapper;
import org.apache.tika.parser.html.HtmlHandler;
import org.apache.tika.parser.html.HtmlMapper;
import org.apache.tika.parser.html.XHTMLDowngradeHandler;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParser
extends AbstractParser {
    private static final long serialVersionUID = 7895315240498733128L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.text((String)"html"), MediaType.application((String)"xhtml+xml"), MediaType.application((String)"vnd.wap.xhtml+xml"), MediaType.application((String)"x-asp"))));
    private static final ServiceLoader LOADER = new ServiceLoader(HtmlParser.class.getClassLoader());
    private static final Schema HTML_SCHEMA = new HTMLSchema();

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        AutoDetectReader reader = new AutoDetectReader((InputStream)new CloseShieldInputStream(stream), metadata, (ServiceLoader)context.get(ServiceLoader.class, (Object)LOADER));
        try {
            Charset charset = reader.getCharset();
            String previous = metadata.get("Content-Type");
            if (previous == null || previous.startsWith("text/html")) {
                MediaType type = new MediaType(MediaType.TEXT_HTML, charset);
                metadata.set("Content-Type", type.toString());
            }
            metadata.set("Content-Encoding", charset.name());
            HtmlMapper mapper = (HtmlMapper)context.get(HtmlMapper.class, (Object)new HtmlParserMapper());
            Parser parser = new Parser();
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)HTML_SCHEMA);
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
            parser.setContentHandler((ContentHandler)((Object)new XHTMLDowngradeHandler((ContentHandler)((Object)new HtmlHandler(mapper, handler, metadata)))));
            parser.parse(reader.asInputSource());
        }
        finally {
            reader.close();
        }
    }

    protected String mapSafeElement(String name) {
        return DefaultHtmlMapper.INSTANCE.mapSafeElement(name);
    }

    protected boolean isDiscardElement(String name) {
        return DefaultHtmlMapper.INSTANCE.isDiscardElement(name);
    }

    public String mapSafeAttribute(String elementName, String attributeName) {
        return DefaultHtmlMapper.INSTANCE.mapSafeAttribute(elementName, attributeName);
    }

    private class HtmlParserMapper
    implements HtmlMapper {
        private HtmlParserMapper() {
        }

        public String mapSafeElement(String name) {
            return HtmlParser.this.mapSafeElement(name);
        }

        public boolean isDiscardElement(String name) {
            return HtmlParser.this.isDiscardElement(name);
        }

        public String mapSafeAttribute(String elementName, String attributeName) {
            return HtmlParser.this.mapSafeAttribute(elementName, attributeName);
        }
    }
}

