/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisFile;

public class TestVorbisFileWrite
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testVORBIS.ogg");
    }

    public void testReadWrite() throws IOException {
        VorbisAudioData vad;
        OggFile in = new OggFile(this.getTestFile());
        VorbisFile vfIN = new VorbisFile(in);
        int infoSize = vfIN.getInfo().getData().length;
        int commentSize = vfIN.getComment().getData().length;
        int setupSize = vfIN.getSetup().getData().length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        VorbisFile vfOUT = new VorbisFile((OutputStream)baos, vfIN.getInfo(), vfIN.getComment(), vfIN.getSetup());
        while ((vad = vfIN.getNextAudioPacket()) != null) {
            vfOUT.writeAudioData(vad);
        }
        vfIN.close();
        vfOUT.close();
        TestVorbisFileWrite.assertEquals((int)infoSize, (int)vfOUT.getInfo().getData().length);
        TestVorbisFileWrite.assertEquals((int)commentSize, (int)vfOUT.getComment().getData().length);
        TestVorbisFileWrite.assertEquals((int)setupSize, (int)vfOUT.getSetup().getData().length);
    }

    public void testReadWriteRead() throws IOException {
        VorbisAudioData vad;
        OggFile in = new OggFile(this.getTestFile());
        VorbisFile vfOrig = new VorbisFile(in);
        int infoSize = vfOrig.getInfo().getData().length;
        int commentSize = vfOrig.getComment().getData().length;
        int setupSize = vfOrig.getSetup().getData().length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        VorbisFile vfOUT = new VorbisFile((OutputStream)baos, vfOrig.getInfo(), vfOrig.getComment(), vfOrig.getSetup());
        while ((vad = vfOrig.getNextAudioPacket()) != null) {
            vfOUT.writeAudioData(vad);
        }
        vfOrig.close();
        vfOUT.close();
        VorbisFile vfIN = new VorbisFile(new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray())));
        TestVorbisFileWrite.assertEquals((int)2, (int)vfIN.getInfo().getChannels());
        TestVorbisFileWrite.assertEquals((long)44100L, (long)vfIN.getInfo().getRate());
        TestVorbisFileWrite.assertEquals((int)0, (int)vfIN.getInfo().getBitrateLower());
        TestVorbisFileWrite.assertEquals((int)0, (int)vfIN.getInfo().getBitrateUpper());
        TestVorbisFileWrite.assertEquals((int)80000, (int)vfIN.getInfo().getBitrateNominal());
        TestVorbisFileWrite.assertEquals((String)"Test Title", (String)vfIN.getComment().getTitle());
        TestVorbisFileWrite.assertEquals((String)"Test Artist", (String)vfIN.getComment().getArtist());
        TestVorbisFileWrite.assertNotNull((Object)vfIN.getNextAudioPacket());
        TestVorbisFileWrite.assertNotNull((Object)vfIN.getNextAudioPacket());
        TestVorbisFileWrite.assertNotNull((Object)vfIN.getNextAudioPacket());
        TestVorbisFileWrite.assertNotNull((Object)vfIN.getNextAudioPacket());
        VorbisAudioData ad = vfIN.getNextAudioPacket();
        TestVorbisFileWrite.assertEquals((long)960L, (long)ad.getGranulePosition());
        TestVorbisFileWrite.assertEquals((int)infoSize, (int)vfOUT.getInfo().getData().length);
        TestVorbisFileWrite.assertEquals((int)commentSize, (int)vfOUT.getComment().getData().length);
        TestVorbisFileWrite.assertEquals((int)setupSize, (int)vfOUT.getSetup().getData().length);
        TestVorbisFileWrite.assertEquals((int)infoSize, (int)vfIN.getInfo().getData().length);
        TestVorbisFileWrite.assertEquals((int)commentSize, (int)vfIN.getComment().getData().length);
        TestVorbisFileWrite.assertEquals((int)setupSize, (int)vfIN.getSetup().getData().length);
    }
}

