/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Service;
import com.google.common.base.Throwables;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractService
implements Service {
    private final ReentrantLock lock = new ReentrantLock();
    private final Transition startup = new Transition();
    private final Transition shutdown = new Transition();
    private Service.State state = Service.State.NEW;
    private boolean shutdownWhenStartupFinishes = false;

    protected abstract void doStart();

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<Service.State> start() {
        this.lock.lock();
        try {
            if (this.state == Service.State.NEW) {
                this.state = Service.State.STARTING;
                this.doStart();
            }
        }
        catch (Throwable startupFailure) {
            this.notifyFailed(startupFailure);
        }
        finally {
            this.lock.unlock();
        }
        return this.startup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<Service.State> stop() {
        this.lock.lock();
        try {
            if (this.state == Service.State.NEW) {
                this.state = Service.State.TERMINATED;
                this.startup.transitionSucceeded(Service.State.TERMINATED);
                this.shutdown.transitionSucceeded(Service.State.TERMINATED);
            } else if (this.state == Service.State.STARTING) {
                this.shutdownWhenStartupFinishes = true;
                this.startup.transitionSucceeded(Service.State.STOPPING);
            } else if (this.state == Service.State.RUNNING) {
                this.state = Service.State.STOPPING;
                this.doStop();
            }
        }
        catch (Throwable shutdownFailure) {
            this.notifyFailed(shutdownFailure);
        }
        finally {
            this.lock.unlock();
        }
        return this.shutdown;
    }

    public Service.State startAndWait() {
        try {
            return this.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public Service.State stopAndWait() {
        try {
            return this.stop().get();
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyStarted() {
        this.lock.lock();
        try {
            if (this.state != Service.State.STARTING) {
                IllegalStateException failure = new IllegalStateException("Cannot notifyStarted() when the service is " + this.state);
                this.notifyFailed(failure);
                throw failure;
            }
            this.state = Service.State.RUNNING;
            if (this.shutdownWhenStartupFinishes) {
                this.stop();
            } else {
                this.startup.transitionSucceeded(Service.State.RUNNING);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyStopped() {
        this.lock.lock();
        try {
            if (this.state != Service.State.STOPPING && this.state != Service.State.RUNNING) {
                IllegalStateException failure = new IllegalStateException("Cannot notifyStopped() when the service is " + this.state);
                this.notifyFailed(failure);
                throw failure;
            }
            this.state = Service.State.TERMINATED;
            this.shutdown.transitionSucceeded(Service.State.TERMINATED);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyFailed(Throwable cause) {
        Preconditions.checkNotNull((Object)cause);
        this.lock.lock();
        try {
            if (this.state == Service.State.STARTING) {
                this.startup.transitionFailed(cause);
                this.shutdown.transitionFailed(new Exception("Service failed to start.", cause));
            } else if (this.state == Service.State.STOPPING) {
                this.shutdown.transitionFailed(cause);
            }
            this.state = Service.State.FAILED;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final boolean isRunning() {
        return this.state() == Service.State.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Service.State state() {
        this.lock.lock();
        try {
            if (this.shutdownWhenStartupFinishes && this.state == Service.State.STARTING) {
                Service.State state = Service.State.STOPPING;
                return state;
            }
            Service.State state = this.state;
            return state;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.state() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Transition
    implements Future<Service.State> {
        private final CountDownLatch done = new CountDownLatch(1);
        private Service.State result;
        private Throwable failureCause;

        private Transition() {
        }

        void transitionSucceeded(Service.State result) {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0);
            this.result = result;
            this.done.countDown();
        }

        void transitionFailed(Throwable cause) {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0);
            this.result = Service.State.FAILED;
            this.failureCause = cause;
            this.done.countDown();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done.getCount() == 0L;
        }

        @Override
        public Service.State get() throws InterruptedException, ExecutionException {
            this.done.await();
            return this.getImmediately();
        }

        @Override
        public Service.State get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.done.await(timeout, unit)) {
                return this.getImmediately();
            }
            throw new TimeoutException(AbstractService.this.toString());
        }

        private Service.State getImmediately() throws ExecutionException {
            if (this.result == Service.State.FAILED) {
                throw new ExecutionException(this.failureCause);
            }
            return this.result;
        }
    }
}

