/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Locale;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public final class NameToIdentifier
implements ReferenceIdentifier {
    private final GenericName name;

    public NameToIdentifier(GenericName genericName) {
        ArgumentChecks.ensureNonNull("name", genericName);
        this.name = genericName;
    }

    @Override
    public Citation getAuthority() {
        NameSpace nameSpace = this.name.scope();
        if (nameSpace != null && !nameSpace.isGlobal()) {
            return Citations.fromName(nameSpace.name().tip().toString());
        }
        return null;
    }

    public static String getCodespaceOrAuthority(GenericName genericName, Locale locale) {
        NameSpace nameSpace;
        String string = NameToIdentifier.getCodeSpace(genericName, locale);
        if (string == null && (nameSpace = genericName.scope()) != null && !nameSpace.isGlobal()) {
            string = NameToIdentifier.toString(nameSpace.name().tip(), locale);
        }
        return string;
    }

    public static String getCodeSpace(GenericName genericName, Locale locale) {
        if (genericName != null) {
            if (genericName instanceof ScopedName) {
                return NameToIdentifier.toString(((ScopedName)genericName).path(), locale);
            }
            if (genericName.depth() == 2) {
                return NameToIdentifier.toString(genericName.head(), locale);
            }
        }
        return null;
    }

    @Override
    public String getCodeSpace() {
        return NameToIdentifier.getCodeSpace(this.name, null);
    }

    @Override
    public String getCode() {
        return this.name.tip().toString();
    }

    @Override
    public String getVersion() {
        return null;
    }

    public int hashCode() {
        return ~Objects.hashCode(this.name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return Objects.equals(this.name, ((NameToIdentifier)object).name);
        }
        return false;
    }

    public String toString() {
        String string = this.getCode();
        String string2 = this.getCodeSpace();
        if (string2 != null && !string2.isEmpty()) {
            return string2 + ':' + string;
        }
        return string;
    }

    public static String toString(GenericName genericName, Locale locale) {
        if (genericName != null) {
            String string;
            InternationalString internationalString;
            if (locale != null && (internationalString = genericName.toInternationalString()) != null && (string = internationalString.toString(locale)) != null) {
                return string;
            }
            return genericName.toString();
        }
        return null;
    }
}

