/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.KeywordCase;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;

public class WKTFormat
extends CompoundFormat<Object> {
    private static final long serialVersionUID = -2909110214650709560L;
    public static final int SINGLE_LINE = -1;
    static final byte DEFAULT_INDENTATION = 2;
    static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.S";
    static final String SHORT_DATE_PATTERN = "yyyy-MM-dd";
    private Symbols symbols;
    private Colors colors;
    private Convention convention = Convention.DEFAULT;
    private Citation authority;
    private KeywordCase keywordCase;
    private boolean isNonAsciiAllowed;
    private byte indentation;
    private transient Formatter formatter;

    public WKTFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.symbols = Symbols.getDefault();
        this.keywordCase = KeywordCase.DEFAULT;
        this.indentation = (byte)2;
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        if (!symbols.equals(this.symbols)) {
            this.symbols = symbols.immutable();
            this.formatter = null;
        }
    }

    public boolean isNonAsciiAllowed() {
        return this.isNonAsciiAllowed || this.convention == Convention.INTERNAL;
    }

    public void setNonAsciiAllowed(boolean bl) {
        this.isNonAsciiAllowed = bl;
    }

    public KeywordCase getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(KeywordCase keywordCase) {
        ArgumentChecks.ensureNonNull("keywordCase", (Object)keywordCase);
        this.keywordCase = keywordCase;
        this.updateFormatter(this.formatter);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        if (colors != null) {
            colors = colors.immutable();
        }
        this.colors = colors;
        this.updateFormatter(this.formatter);
    }

    public Convention getConvention() {
        return this.convention;
    }

    public void setConvention(Convention convention) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        this.convention = convention;
        this.updateFormatter(this.formatter);
    }

    public Citation getNameAuthority() {
        Citation citation = this.authority;
        if (citation == null) {
            citation = this.convention.getNameAuthority();
        }
        return citation;
    }

    public void setNameAuthority(Citation citation) {
        this.authority = citation;
        this.updateFormatter(this.formatter);
    }

    private void updateFormatter(Formatter formatter) {
        if (formatter != null) {
            boolean bl;
            switch (this.keywordCase) {
                case UPPER_CASE: {
                    bl = true;
                    break;
                }
                case CAMEL_CASE: {
                    bl = false;
                    break;
                }
                default: {
                    bl = this.convention.majorVersion() == 1;
                }
            }
            formatter.configure(this.convention, this.authority, this.colors, bl, this.indentation);
            formatter.isNonAsciiAllowed |= this.isNonAsciiAllowed;
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) {
        ArgumentChecks.ensureBetween("indentation", -1, 127, n);
        this.indentation = (byte)n;
        this.updateFormatter(this.formatter);
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(Object object, Appendable appendable) throws IOException {
        boolean bl;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        StringBuffer stringBuffer = appendable instanceof StringBuffer ? (StringBuffer)appendable : new StringBuffer(500);
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = new Formatter(this.getLocale(), this.symbols, (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class));
            this.updateFormatter(formatter);
            this.formatter = formatter;
        }
        try {
            formatter.setBuffer(stringBuffer);
            bl = formatter.appendElement(object) || formatter.appendValue(object);
        }
        finally {
            formatter.setBuffer(null);
            formatter.clear();
        }
        if (!bl) {
            throw new ClassCastException(Errors.format((short)28, "object", object.getClass()));
        }
        if (stringBuffer != appendable) {
            appendable.append(stringBuffer);
        }
    }

    @Override
    protected Format createFormat(Class<?> clazz) {
        if (clazz == Number.class) {
            return this.symbols.createNumberFormat();
        }
        if (clazz == Date.class) {
            TimeZone timeZone = this.getTimeZone();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("UTC".equals(timeZone.getID()) ? "yyyy-MM-dd'T'HH:mm:ss.S'Z'" : DATE_PATTERN, this.symbols.getLocale());
            simpleDateFormat.setTimeZone(timeZone);
            return simpleDateFormat;
        }
        return super.createFormat(clazz);
    }

    public String getWarning() {
        return this.formatter != null ? this.formatter.getErrorMessage() : null;
    }

    @Override
    public WKTFormat clone() {
        WKTFormat wKTFormat = (WKTFormat)super.clone();
        wKTFormat.formatter = null;
        return wKTFormat;
    }
}

