/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.sis.util.resources.Errors;

public class Cloner {
    private Class<?> type;
    private Method method;

    protected boolean isCloneRequired(Object object) {
        return true;
    }

    public Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        SecurityException securityException = null;
        Class<?> clazz = object.getClass();
        try {
            if (clazz != this.type) {
                this.method = clazz.getMethod("clone", null);
                this.type = clazz;
                if (!Modifier.isPublic(this.method.getDeclaringClass().getModifiers())) {
                    try {
                        this.method.setAccessible(true);
                    }
                    catch (SecurityException securityException2) {
                        securityException = securityException2;
                    }
                }
            }
            if (this.method != null) {
                return this.method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.isCloneRequired(object)) {
                throw this.fail(noSuchMethodException);
            }
            this.method = null;
            this.type = clazz;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.fail(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof CloneNotSupportedException) {
                throw (CloneNotSupportedException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw this.fail(invocationTargetException);
        }
        catch (SecurityException securityException3) {
            throw this.fail(securityException3);
        }
        return object;
    }

    private CloneNotSupportedException fail(Throwable throwable) {
        CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException(Errors.format((short)13, this.type));
        cloneNotSupportedException.initCause(throwable);
        return cloneNotSupportedException;
    }
}

