/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapWithSpecialCases;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.metadata.Identifier;

final class NilObjectHandler
implements InvocationHandler {
    private final Object attribute;

    NilObjectHandler(Identifier[] identifierArray) {
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>(identifierArray.length);
        for (Identifier identifier : identifierArray) {
            if (identifier == null) continue;
            arrayList.add(identifier);
        }
        this.attribute = new IdentifierMapWithSpecialCases(arrayList);
    }

    NilObjectHandler(NilReason nilReason) {
        this.attribute = nilReason;
    }

    static boolean isIgnoredInterface(Class<?> clazz) {
        return IdentifiedObject.class.isAssignableFrom(clazz) || NilObject.class.isAssignableFrom(clazz) || LenientComparable.class.isAssignableFrom(clazz);
    }

    private static Class<?> getInterface(Object object) {
        for (Class<?> clazz : object.getClass().getInterfaces()) {
            if (NilObjectHandler.isIgnoredInterface(clazz)) continue;
            return clazz;
        }
        throw new AssertionError(object);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (objectArray == null) {
            if ("getNilReason".equals(string)) {
                return this.attribute instanceof NilReason ? (NilReason)this.attribute : null;
            }
            if ("getIdentifierMap".equals(string)) {
                return this.attribute instanceof IdentifierMap ? (IdentifierMap)this.attribute : null;
            }
            if ("getIdentifiers".equals(string)) {
                return this.attribute instanceof IdentifierMapAdapter ? ((IdentifierMapAdapter)this.attribute).identifiers : null;
            }
            if ("toString".equals(string)) {
                return NilObjectHandler.getInterface(object).getSimpleName() + '[' + this.attribute + ']';
            }
            if ("hashCode".equals(string)) {
                return ~this.attribute.hashCode();
            }
            if (string.startsWith("get") || string.startsWith("is")) {
                return Numbers.valueOfNil(method.getReturnType());
            }
        } else {
            switch (objectArray.length) {
                case 1: {
                    if (string.equals("equals")) {
                        return this.equals(object, objectArray[0], ComparisonMode.STRICT);
                    }
                    if (!string.startsWith("set")) break;
                    throw new UnsupportedOperationException(Errors.format((short)123, NilObjectHandler.getInterface(object)));
                }
                case 2: {
                    if (!string.equals("equals")) break;
                    return this.equals(object, objectArray[0], (ComparisonMode)((Object)objectArray[1]));
                }
            }
        }
        throw new UnsupportedOperationException(Errors.format((short)128, NilObjectHandler.getInterface(object).getSimpleName() + '.' + string));
    }

    /*
     * WARNING - void declaration
     */
    private boolean equals(Object object, Object object2, ComparisonMode comparisonMode) throws Throwable {
        Object object3;
        if (object2 == object) {
            return true;
        }
        if (object2 == null) {
            return false;
        }
        if (object.getClass() == object2.getClass()) {
            if (comparisonMode.ordinal() >= ComparisonMode.IGNORE_METADATA.ordinal()) {
                return true;
            }
            NilObjectHandler nilObjectHandler = (NilObjectHandler)Proxy.getInvocationHandler(object2);
            return this.attribute.equals(nilObjectHandler.attribute);
        }
        switch (comparisonMode) {
            case STRICT: {
                return false;
            }
            case BY_CONTRACT: {
                void var5_9;
                object3 = this.attribute;
                Object object4 = null;
                if (object3 instanceof IdentifierMapAdapter) {
                    object3 = ((IdentifierMapAdapter)object3).identifiers;
                    if (object2 instanceof IdentifiedObject) {
                        Collection<? extends Identifier> collection = ((IdentifiedObject)object2).getIdentifiers();
                    }
                } else if (object2 instanceof NilObject) {
                    NilReason nilReason = ((NilObject)object2).getNilReason();
                }
                if (Objects.equals(object3, var5_9)) break;
                return false;
            }
        }
        object3 = NilObjectHandler.getInterface(object);
        if (!((Class)object3).isInstance(object2)) {
            return false;
        }
        for (Method method : ((Class)object3).getMethods()) {
            Object object4;
            if (!Classes.isPossibleGetter(method)) continue;
            try {
                object4 = method.invoke(object2, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            if (object4 == null || object4 instanceof Collection && ((Collection)object4).isEmpty() || object4 instanceof Map && ((Map)object4).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

