/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerStream;
import opennlp.tools.tokenize.WhitespaceTokenStream;
import opennlp.tools.util.PlainTextByLineStream;

final class CommandLineTokenizer {
    private final Tokenizer tokenizer;

    CommandLineTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    void process() {
        PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
        WhitespaceTokenStream tokenizedLineStream = new WhitespaceTokenStream(new TokenizerStream(this.tokenizer, untokenizedLineStream));
        PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
        perfMon.start();
        try {
            String tokenizedLine;
            while ((tokenizedLine = (String)tokenizedLineStream.read()) != null) {
                System.out.println(tokenizedLine);
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

