/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TrainedModel;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public abstract class TrainedModelDetector
implements Detector {
    private final Map<MediaType, TrainedModel> MODEL_MAP = new HashMap<MediaType, TrainedModel>();
    private static final long serialVersionUID = 1L;

    public TrainedModelDetector() {
        this.loadDefaultModels(this.getClass().getClassLoader());
    }

    public int getMinLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input != null) {
            float threshold;
            input.mark(this.getMinLength());
            float[] histogram = this.readByteFrequencies(input);
            Iterator<MediaType> iter = this.MODEL_MAP.keySet().iterator();
            float maxprob = threshold = 0.5f;
            MediaType maxType = MediaType.OCTET_STREAM;
            while (iter.hasNext()) {
                MediaType key = iter.next();
                TrainedModel model = this.MODEL_MAP.get(key);
                float prob = model.predict(histogram);
                if (!(maxprob < prob)) continue;
                maxprob = prob;
                maxType = key;
            }
            input.reset();
            return maxType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float[] readByteFrequencies(InputStream input) throws IOException {
        ReadableByteChannel inputChannel = null;
        inputChannel = Channels.newChannel(input);
        float[] histogram = new float[257];
        histogram[0] = 1.0f;
        ByteBuffer buf = ByteBuffer.allocate(5120);
        int bytesRead = inputChannel.read(buf);
        float max = -1.0f;
        while (bytesRead != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                int byt;
                int idx = byt = buf.get();
                ++idx;
                if (byt < 0) {
                    int n = idx = 256 + idx;
                    histogram[n] = histogram[n] + 1.0f;
                } else {
                    int n = idx;
                    histogram[n] = histogram[n] + 1.0f;
                }
                max = max < histogram[idx] ? histogram[idx] : max;
            }
            buf.clear();
            bytesRead = inputChannel.read(buf);
        }
        for (int i = 1; i < histogram.length; ++i) {
            int n = i;
            histogram[n] = histogram[n] / max;
            histogram[i] = (float)Math.sqrt(histogram[i]);
        }
        float[] fArray = histogram;
        return fArray;
    }

    private synchronized void writeHisto(float[] histogram) throws IOException {
        String histPath = new TemporaryResources().createTemporaryFile().getAbsolutePath();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(histPath), "UTF-8");
        int n = histogram.length;
        for (int i = 0; i < n; ++i) {
            writer.write(new StringBuffer().append(histogram[i]).append("\t").toString());
        }
        writer.write("\r\n");
        ((Writer)writer).flush();
    }

    public void loadDefaultModels(File modelFile) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(modelFile);
            this.loadDefaultModels(in);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to read the default media type registry", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the default media type registry", e);
            }
        }
    }

    public abstract void loadDefaultModels(InputStream var1);

    public abstract void loadDefaultModels(ClassLoader var1);

    protected void registerModels(MediaType type, TrainedModel model) {
        this.MODEL_MAP.put(type, model);
    }
}

