/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public final class SlideShowDumper {
    private NPOIFSFileSystem filesystem;
    private byte[] _docstream;
    private boolean ddfEscher = false;
    private boolean basicEscher = false;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Useage: SlideShowDumper [-escher|-basicescher] <filename>");
            return;
        }
        String filename = args[0];
        if (args.length > 1) {
            filename = args[1];
        }
        SlideShowDumper foo = new SlideShowDumper(filename);
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("-escher")) {
                foo.setDDFEscher(true);
            } else {
                foo.setBasicEscher(true);
            }
        }
        foo.printDump();
        foo.close();
    }

    public SlideShowDumper(String fileName) throws IOException {
        this(new NPOIFSFileSystem(new File(fileName)));
    }

    public SlideShowDumper(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    public SlideShowDumper(NPOIFSFileSystem filesystem) throws IOException {
        this.filesystem = filesystem;
        DocumentEntry docProps = (DocumentEntry)filesystem.getRoot().getEntry("PowerPoint Document");
        this._docstream = new byte[docProps.getSize()];
        filesystem.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    public void setDDFEscher(boolean grok) {
        this.ddfEscher = grok;
        this.basicEscher = !grok;
    }

    public void setBasicEscher(boolean grok) {
        this.basicEscher = grok;
        this.ddfEscher = !grok;
    }

    public void close() throws IOException {
        this.filesystem.close();
    }

    public void printDump() {
        this.walkTree(0, 0, this._docstream.length);
    }

    public String makeHex(short s) {
        String hex = Integer.toHexString(s).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    public String makeHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "000" + hex;
        }
        if (hex.length() == 2) {
            return "00" + hex;
        }
        if (hex.length() == 3) {
            return "0" + hex;
        }
        return hex;
    }

    public void walkTree(int depth, int startPos, int maxLen) {
        long len;
        int endPos = startPos + maxLen;
        int indent = depth;
        for (int pos = startPos; pos <= endPos - 8; pos += (int)len) {
            long type = LittleEndian.getUShort((byte[])this._docstream, (int)(pos + 2));
            len = LittleEndian.getUInt((byte[])this._docstream, (int)(pos + 4));
            byte opt = this._docstream[pos];
            String ind = "";
            for (int i = 0; i < indent; ++i) {
                ind = ind + " ";
            }
            System.out.println(ind + "At position " + pos + " (" + this.makeHex(pos) + "):");
            System.out.println(ind + "Type is " + type + " (" + this.makeHex((int)type) + "), len is " + len + " (" + this.makeHex((int)len) + ")");
            String recordName = RecordTypes.recordName((int)type);
            pos += 8;
            if (recordName != null) {
                System.out.println(ind + "That's a " + recordName);
                int container = opt & 0xF;
                if (type == 5003L && (long)opt == 0L) {
                    container = 15;
                }
                if (type == 0L || container != 15) {
                    System.out.println();
                    continue;
                }
                if (type == 1035L || type == 1036L) {
                    System.out.println();
                    if (this.ddfEscher) {
                        this.walkEscherDDF(indent + 3, pos + 8, (int)len - 8);
                        continue;
                    }
                    if (!this.basicEscher) continue;
                    this.walkEscherBasic(indent + 3, pos + 8, (int)len - 8);
                    continue;
                }
                System.out.println();
                this.walkTree(indent + 2, pos, (int)len);
                continue;
            }
            System.out.println(ind + "** unknown record **");
            System.out.println();
        }
    }

    public void walkEscherDDF(int indent, int pos, int len) {
        if (len < 8) {
            return;
        }
        String ind = "";
        for (int i = 0; i < indent; ++i) {
            ind = ind + " ";
        }
        byte[] contents = new byte[len];
        System.arraycopy(this._docstream, pos, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        EscherRecord record = erf.createRecord(contents, 0);
        record.fillFields(contents, 0, (EscherRecordFactory)erf);
        long atomType = LittleEndian.getUShort((byte[])contents, (int)2);
        long atomLen = LittleEndian.getUShort((byte[])contents, (int)4);
        int recordLen = record.getRecordSize();
        System.out.println(ind + "At position " + pos + " (" + this.makeHex(pos) + "):");
        System.out.println(ind + "Type is " + atomType + " (" + this.makeHex((int)atomType) + "), len is " + atomLen + " (" + this.makeHex((int)atomLen) + ") (" + (atomLen + 8L) + ") - record claims " + recordLen);
        if (recordLen != 8 && (long)recordLen != atomLen + 8L) {
            System.out.println(ind + "** Atom length of " + atomLen + " (" + (atomLen + 8L) + ") doesn't match record length of " + recordLen);
        }
        if (record instanceof EscherContainerRecord) {
            EscherContainerRecord ecr = (EscherContainerRecord)record;
            System.out.println(ind + ecr.toString());
            this.walkEscherDDF(indent + 3, pos + 8, (int)atomLen);
        } else {
            System.out.println(ind + record.toString());
        }
        if (atomType == 61451L) {
            recordLen = (int)atomLen + 8;
        }
        if (atomType == 61453L) {
            recordLen = (int)atomLen + 8;
            record.fillFields(contents, 0, (EscherRecordFactory)erf);
            if (!(record instanceof EscherTextboxRecord)) {
                System.out.println(ind + "** Really a msofbtClientTextbox !");
            }
        }
        if (recordLen == 8 && atomLen > 8L) {
            this.walkEscherDDF(indent + 3, pos + 8, (int)atomLen);
            pos = (int)((long)pos + atomLen);
            pos += 8;
            len = (int)((long)len - atomLen);
            len -= 8;
        } else {
            pos = (int)((long)pos + atomLen);
            pos += 8;
            len = (int)((long)len - atomLen);
            len -= 8;
        }
        if (len >= 8) {
            this.walkEscherDDF(indent, pos, len);
        }
    }

    public void walkEscherBasic(int indent, int pos, int len) {
        if (len < 8) {
            return;
        }
        String ind = "";
        for (int i = 0; i < indent; ++i) {
            ind = ind + " ";
        }
        long type = LittleEndian.getUShort((byte[])this._docstream, (int)(pos + 2));
        long atomlen = LittleEndian.getUInt((byte[])this._docstream, (int)(pos + 4));
        String typeS = this.makeHex((int)type);
        System.out.println(ind + "At position " + pos + " (" + this.makeHex(pos) + "):");
        System.out.println(ind + "Type is " + type + " (" + typeS + "), len is " + atomlen + " (" + this.makeHex((int)atomlen) + ")");
        String typeName = RecordTypes.recordName((int)type);
        if (typeName != null) {
            System.out.println(ind + "That's an Escher Record: " + typeName);
        } else {
            System.out.println(ind + "(Unknown Escher Record)");
        }
        if (type == 61453L) {
            short bv;
            int i;
            System.out.print(ind);
            for (i = 8; i < 16; ++i) {
                bv = this._docstream[i + pos];
                if (bv < 0) {
                    bv = (short)(bv + 256);
                }
                System.out.print(i + "=" + bv + " (" + this.makeHex(bv) + ")  ");
            }
            System.out.println("");
            System.out.print(ind);
            for (i = 20; i < 28; ++i) {
                bv = this._docstream[i + pos];
                if (bv < 0) {
                    bv = (short)(bv + 256);
                }
                System.out.print(i + "=" + bv + " (" + this.makeHex(bv) + ")  ");
            }
            System.out.println("");
        }
        System.out.println("");
        if (type == 61443L || type == 61444L) {
            this.walkEscherBasic(indent + 3, pos + 8, (int)atomlen);
        }
        if (atomlen < (long)len) {
            int atomleni = (int)atomlen;
            this.walkEscherBasic(indent, pos + atomleni + 8, len - atomleni - 8);
        }
    }
}

