/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Rectangle;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.hslf.model.Line;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.TextBox;

public final class TableCell
extends TextBox {
    protected static final int DEFAULT_WIDTH = 100;
    protected static final int DEFAULT_HEIGHT = 40;
    private Line borderLeft;
    private Line borderRight;
    private Line borderTop;
    private Line borderBottom;

    protected TableCell(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public TableCell(Shape parent) {
        super(parent);
        this.setShapeType(1);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        this._escherContainer = super.createSpContainer(isChild);
        EscherOptRecord opt = this.getEscherOptRecord();
        TableCell.setEscherProperty(opt, (short)128, 0);
        TableCell.setEscherProperty(opt, (short)191, 131072);
        TableCell.setEscherProperty(opt, (short)447, 0x150001);
        TableCell.setEscherProperty(opt, (short)575, 131072);
        TableCell.setEscherProperty(opt, (short)127, 262144);
        return this._escherContainer;
    }

    protected void anchorBorder(int type, Line line) {
        Rectangle cellAnchor = this.getAnchor();
        Rectangle lineAnchor = new Rectangle();
        switch (type) {
            case 1: {
                lineAnchor.x = cellAnchor.x;
                lineAnchor.y = cellAnchor.y;
                lineAnchor.width = cellAnchor.width;
                lineAnchor.height = 0;
                break;
            }
            case 2: {
                lineAnchor.x = cellAnchor.x + cellAnchor.width;
                lineAnchor.y = cellAnchor.y;
                lineAnchor.width = 0;
                lineAnchor.height = cellAnchor.height;
                break;
            }
            case 3: {
                lineAnchor.x = cellAnchor.x;
                lineAnchor.y = cellAnchor.y + cellAnchor.height;
                lineAnchor.width = cellAnchor.width;
                lineAnchor.height = 0;
                break;
            }
            case 4: {
                lineAnchor.x = cellAnchor.x;
                lineAnchor.y = cellAnchor.y;
                lineAnchor.width = 0;
                lineAnchor.height = cellAnchor.height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown border type: " + type);
            }
        }
        line.setAnchor(lineAnchor);
    }

    public Line getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(Line line) {
        if (line != null) {
            this.anchorBorder(4, line);
        }
        this.borderLeft = line;
    }

    public Line getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(Line line) {
        if (line != null) {
            this.anchorBorder(2, line);
        }
        this.borderRight = line;
    }

    public Line getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(Line line) {
        if (line != null) {
            this.anchorBorder(1, line);
        }
        this.borderTop = line;
    }

    public Line getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(Line line) {
        if (line != null) {
            this.anchorBorder(3, line);
        }
        this.borderBottom = line;
    }

    public void setAnchor(Rectangle anchor) {
        super.setAnchor(anchor);
        if (this.borderTop != null) {
            this.anchorBorder(1, this.borderTop);
        }
        if (this.borderRight != null) {
            this.anchorBorder(2, this.borderRight);
        }
        if (this.borderBottom != null) {
            this.anchorBorder(3, this.borderBottom);
        }
        if (this.borderLeft != null) {
            this.anchorBorder(4, this.borderLeft);
        }
    }
}

