/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.poi.hslf.blip.BitmapPainter;
import org.apache.poi.hslf.blip.DIB;
import org.apache.poi.hslf.blip.EMF;
import org.apache.poi.hslf.blip.ImagePainter;
import org.apache.poi.hslf.blip.JPEG;
import org.apache.poi.hslf.blip.PICT;
import org.apache.poi.hslf.blip.PNG;
import org.apache.poi.hslf.blip.WMF;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class PictureData {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    protected static final int CHECKSUM_SIZE = 16;
    private byte[] rawdata;
    protected int offset;
    protected int uidInstanceCount = 1;
    protected static final ImagePainter[] painters = new ImagePainter[8];

    public abstract int getType();

    public abstract byte[] getData();

    public abstract void setData(byte[] var1) throws IOException;

    public abstract int getSignature();

    public abstract void setSignature(int var1);

    protected int getUIDInstanceCount() {
        return this.uidInstanceCount;
    }

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void setRawData(byte[] data) {
        this.rawdata = data;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getUID() {
        byte[] uid = new byte[16];
        System.arraycopy(this.rawdata, 0, uid, 0, uid.length);
        return uid;
    }

    public static byte[] getChecksum(byte[] data) {
        MessageDigest md5 = CryptoFunctions.getMessageDigest((HashAlgorithm)HashAlgorithm.md5);
        md5.update(data);
        return md5.digest();
    }

    public void write(OutputStream out) throws IOException {
        byte[] data = new byte[2];
        LittleEndian.putUShort((byte[])data, (int)0, (int)this.getSignature());
        out.write(data);
        data = new byte[2];
        LittleEndian.putUShort((byte[])data, (int)0, (int)(this.getType() + 61464));
        out.write(data);
        byte[] rawdata = this.getRawData();
        data = new byte[4];
        LittleEndian.putInt((byte[])data, (int)0, (int)rawdata.length);
        out.write(data);
        out.write(rawdata);
    }

    public static PictureData create(int type) {
        PictureData pict;
        switch (type) {
            case 2: {
                pict = new EMF();
                break;
            }
            case 3: {
                pict = new WMF();
                break;
            }
            case 4: {
                pict = new PICT();
                break;
            }
            case 5: {
                pict = new JPEG();
                break;
            }
            case 6: {
                pict = new PNG();
                break;
            }
            case 7: {
                pict = new DIB();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported picture type: " + type);
            }
        }
        return pict;
    }

    public byte[] getHeader() {
        byte[] header = new byte[24];
        LittleEndian.putInt((byte[])header, (int)0, (int)this.getSignature());
        LittleEndian.putInt((byte[])header, (int)4, (int)this.getRawData().length);
        System.arraycopy(this.rawdata, 0, header, 8, 16);
        return header;
    }

    public int getSize() {
        return this.getData().length;
    }

    public void draw(Graphics2D graphics, Picture parent) {
        ImagePainter painter = painters[this.getType()];
        if (painter != null) {
            painter.paint(graphics, this, parent);
        } else {
            this.logger.log(5, new Object[]{"Rendering is not supported: " + this.getClass().getName()});
        }
    }

    public static void setImagePainter(int type, ImagePainter painter) {
        PictureData.painters[type] = painter;
    }

    public static ImagePainter getImagePainter(int type) {
        return painters[type];
    }

    static {
        PictureData.setImagePainter(6, new BitmapPainter());
        PictureData.setImagePainter(5, new BitmapPainter());
        PictureData.setImagePainter(7, new BitmapPainter());
    }
}

