/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.ConditionType;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFBorderFormatting;
import org.apache.poi.xssf.usermodel.XSSFFontFormatting;
import org.apache.poi.xssf.usermodel.XSSFPatternFormatting;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;

public class XSSFConditionalFormattingRule
implements ConditionalFormattingRule {
    private final CTCfRule _cfRule;
    private XSSFSheet _sh;
    private static Map<STCfType.Enum, ConditionType> typeLookup = new HashMap<STCfType.Enum, ConditionType>();

    XSSFConditionalFormattingRule(XSSFSheet sh) {
        this._cfRule = CTCfRule.Factory.newInstance();
        this._sh = sh;
    }

    XSSFConditionalFormattingRule(XSSFSheet sh, CTCfRule cfRule) {
        this._cfRule = cfRule;
        this._sh = sh;
    }

    CTCfRule getCTCfRule() {
        return this._cfRule;
    }

    CTDxf getDxf(boolean create) {
        int dxfId;
        StylesTable styles = this._sh.getWorkbook().getStylesSource();
        CTDxf dxf = null;
        if (styles._getDXfsSize() > 0 && this._cfRule.isSetDxfId()) {
            dxfId = (int)this._cfRule.getDxfId();
            dxf = styles.getDxfAt(dxfId);
        }
        if (create && dxf == null) {
            dxf = CTDxf.Factory.newInstance();
            dxfId = styles.putDxf(dxf);
            this._cfRule.setDxfId((long)(dxfId - 1));
        }
        return dxf;
    }

    public XSSFBorderFormatting createBorderFormatting() {
        CTDxf dxf = this.getDxf(true);
        CTBorder border = !dxf.isSetBorder() ? dxf.addNewBorder() : dxf.getBorder();
        return new XSSFBorderFormatting(border);
    }

    public XSSFBorderFormatting getBorderFormatting() {
        CTDxf dxf = this.getDxf(false);
        if (dxf == null || !dxf.isSetBorder()) {
            return null;
        }
        return new XSSFBorderFormatting(dxf.getBorder());
    }

    public XSSFFontFormatting createFontFormatting() {
        CTDxf dxf = this.getDxf(true);
        CTFont font = !dxf.isSetFont() ? dxf.addNewFont() : dxf.getFont();
        return new XSSFFontFormatting(font);
    }

    public XSSFFontFormatting getFontFormatting() {
        CTDxf dxf = this.getDxf(false);
        if (dxf == null || !dxf.isSetFont()) {
            return null;
        }
        return new XSSFFontFormatting(dxf.getFont());
    }

    public XSSFPatternFormatting createPatternFormatting() {
        CTDxf dxf = this.getDxf(true);
        CTFill fill = !dxf.isSetFill() ? dxf.addNewFill() : dxf.getFill();
        return new XSSFPatternFormatting(fill);
    }

    public XSSFPatternFormatting getPatternFormatting() {
        CTDxf dxf = this.getDxf(false);
        if (dxf == null || !dxf.isSetFill()) {
            return null;
        }
        return new XSSFPatternFormatting(dxf.getFill());
    }

    public byte getConditionType() {
        ConditionType type = this.getConditionTypeType();
        if (type != null) {
            return type.id;
        }
        return 0;
    }

    public ConditionType getConditionTypeType() {
        return typeLookup.get(this._cfRule.getType());
    }

    public byte getComparisonOperation() {
        STConditionalFormattingOperator.Enum op = this._cfRule.getOperator();
        if (op == null) {
            return 0;
        }
        switch (op.intValue()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 6: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    public String getFormula1() {
        return this._cfRule.sizeOfFormulaArray() > 0 ? this._cfRule.getFormulaArray(0) : null;
    }

    public String getFormula2() {
        return this._cfRule.sizeOfFormulaArray() == 2 ? this._cfRule.getFormulaArray(1) : null;
    }

    static {
        typeLookup.put(STCfType.CELL_IS, ConditionType.CELL_VALUE_IS);
        typeLookup.put(STCfType.EXPRESSION, ConditionType.FORMULA);
        typeLookup.put(STCfType.COLOR_SCALE, ConditionType.COLOR_SCALE);
        typeLookup.put(STCfType.DATA_BAR, ConditionType.DATA_BAR);
        typeLookup.put(STCfType.ICON_SET, ConditionType.ICON_SET);
        typeLookup.put(STCfType.TOP_10, ConditionType.FILTER);
        typeLookup.put(STCfType.UNIQUE_VALUES, ConditionType.FILTER);
        typeLookup.put(STCfType.DUPLICATE_VALUES, ConditionType.FILTER);
        typeLookup.put(STCfType.CONTAINS_TEXT, ConditionType.FILTER);
        typeLookup.put(STCfType.NOT_CONTAINS_TEXT, ConditionType.FILTER);
        typeLookup.put(STCfType.BEGINS_WITH, ConditionType.FILTER);
        typeLookup.put(STCfType.ENDS_WITH, ConditionType.FILTER);
        typeLookup.put(STCfType.CONTAINS_BLANKS, ConditionType.FILTER);
        typeLookup.put(STCfType.NOT_CONTAINS_BLANKS, ConditionType.FILTER);
        typeLookup.put(STCfType.CONTAINS_ERRORS, ConditionType.FILTER);
        typeLookup.put(STCfType.NOT_CONTAINS_ERRORS, ConditionType.FILTER);
        typeLookup.put(STCfType.TIME_PERIOD, ConditionType.FILTER);
        typeLookup.put(STCfType.ABOVE_AVERAGE, ConditionType.FILTER);
    }
}

