/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.tika.batch.BatchNoRestartError;
import org.apache.tika.batch.ConsumersManager;
import org.apache.tika.batch.FileConsumerFutureResult;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.FileResourceCrawlerFutureResult;
import org.apache.tika.batch.FileStarted;
import org.apache.tika.batch.IFileProcessorFutureResult;
import org.apache.tika.batch.Interrupter;
import org.apache.tika.batch.InterrupterFutureResult;
import org.apache.tika.batch.ParallelFileProcessingResult;
import org.apache.tika.batch.StatusReporter;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcess
implements Callable<ParallelFileProcessingResult> {
    private static final Logger logger = LoggerFactory.getLogger(BatchProcess.class);
    private PrintStream outputStreamWriter;
    private long timeoutThresholdMillis = 300000L;
    private long timeoutCheckPulseMillis = 120000L;
    private long pauseOnEarlyTerminationMillis = 30000L;
    private final long consumersManagerMaxMillis;
    private int maxAliveTimeSeconds = -1;
    private final FileResourceCrawler fileResourceCrawler;
    private final ConsumersManager consumersManager;
    private final StatusReporter reporter;
    private final Interrupter interrupter;
    private final ArrayBlockingQueue<FileStarted> timedOuts;
    private boolean alreadyExecuted = false;

    public BatchProcess(FileResourceCrawler fileResourceCrawler, ConsumersManager consumersManager, StatusReporter reporter, Interrupter interrupter) {
        this.fileResourceCrawler = fileResourceCrawler;
        this.consumersManager = consumersManager;
        this.reporter = reporter;
        this.interrupter = interrupter;
        this.timedOuts = new ArrayBlockingQueue(consumersManager.getConsumers().size());
        this.consumersManagerMaxMillis = consumersManager.getConsumersManagerMaxMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParallelFileProcessingResult call() throws InterruptedException {
        if (this.alreadyExecuted) {
            throw new IllegalStateException("Can only execute BatchRunner once.");
        }
        PrintStream sysErr = System.err;
        try {
            this.outputStreamWriter = new PrintStream((OutputStream)sysErr, true, IOUtils.UTF_8.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't redirect streams");
        }
        System.setErr(System.out);
        ParallelFileProcessingResult result = null;
        try {
            int numConsumers = this.consumersManager.getConsumers().size();
            int numNonConsumers = 4;
            ExecutorService ex = Executors.newFixedThreadPool(numConsumers + numNonConsumers);
            ExecutorCompletionService<IFileProcessorFutureResult> completionService = new ExecutorCompletionService<IFileProcessorFutureResult>(ex);
            TimeoutChecker timeoutChecker = new TimeoutChecker();
            try {
                this.startConsumersManager();
            }
            catch (BatchNoRestartError e) {
                ParallelFileProcessingResult parallelFileProcessingResult = new ParallelFileProcessingResult(0, 0, 0, 0, 0.0, 254, CAUSE_FOR_TERMINATION.CONSUMERS_MANAGER_DIDNT_INIT_IN_TIME_NO_RESTART.toString());
                this.shutdownConsumersManager();
                return parallelFileProcessingResult;
            }
            State state = this.mainLoop(completionService, timeoutChecker);
            result = this.shutdown(ex, completionService, timeoutChecker, state);
        }
        finally {
            this.shutdownConsumersManager();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private State mainLoop(CompletionService<IFileProcessorFutureResult> completionService, TimeoutChecker timeoutChecker) {
        block9: {
            this.alreadyExecuted = true;
            state = new State();
            BatchProcess.logger.info("BatchProcess starting up");
            state.start = new Date().getTime();
            completionService.submit(this.interrupter);
            completionService.submit(this.fileResourceCrawler);
            completionService.submit(this.reporter);
            completionService.submit(timeoutChecker);
            for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
                completionService.submit(consumer);
            }
            state.numConsumers = this.consumersManager.getConsumers().size();
            causeForTermination = null;
            try {
                do {
                    block11: {
                        block10: {
                            if ((futureResult = completionService.poll(1L, TimeUnit.SECONDS)) == null) ** GOTO lbl-1000
                            ++state.removed;
                            result = futureResult.get();
                            if (!(result instanceof FileConsumerFutureResult)) break block10;
                            ++state.consumersRemoved;
                            ** GOTO lbl-1000
                        }
                        if (!(result instanceof FileResourceCrawlerFutureResult)) break block11;
                        ++state.crawlersRemoved;
                        if (this.fileResourceCrawler.wasTimedOut()) {
                            causeForTermination = CAUSE_FOR_TERMINATION.CRAWLER_TIMED_OUT;
                            break block9;
                        }
                        ** GOTO lbl-1000
                    }
                    if (result instanceof InterrupterFutureResult) {
                        causeForTermination = CAUSE_FOR_TERMINATION.USER_INTERRUPTION;
                    } else if (result instanceof TimeoutFutureResult) {
                        causeForTermination = CAUSE_FOR_TERMINATION.TIMED_OUT_CONSUMER;
                    } else lbl-1000:
                    // 4 sources

                    {
                        if (state.consumersRemoved < state.numConsumers) continue;
                        causeForTermination = CAUSE_FOR_TERMINATION.COMPLETED_NORMALLY;
                    }
                    break block9;
                } while (!this.aliveTooLong(state.start));
                causeForTermination = CAUSE_FOR_TERMINATION.BATCH_PROCESS_ALIVE_TOO_LONG;
            }
            catch (Throwable e) {
                causeForTermination = this.isNonRestart(e) != false ? CAUSE_FOR_TERMINATION.MAIN_LOOP_EXCEPTION_NO_RESTART : CAUSE_FOR_TERMINATION.MAIN_LOOP_EXCEPTION;
                BatchProcess.logger.error("Main loop execution exception: " + e.getMessage());
            }
        }
        state.causeForTermination = causeForTermination;
        return state;
    }

    private ParallelFileProcessingResult shutdown(ExecutorService ex, CompletionService<IFileProcessorFutureResult> completionService, TimeoutChecker timeoutChecker, State state) {
        this.reporter.setIsShuttingDown(true);
        int added = this.fileResourceCrawler.getAdded();
        int considered = this.fileResourceCrawler.getConsidered();
        ex.shutdown();
        for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
            consumer.pleaseShutdown();
        }
        this.fileResourceCrawler.shutDownNoPoison();
        this.politelyAwaitTermination(state.causeForTermination);
        logger.trace("About to shutdownNow()");
        List<Runnable> neverCalled = ex.shutdownNow();
        logger.trace("TERMINATED " + ex.isTerminated() + " : " + state.consumersRemoved + " : " + state.crawlersRemoved);
        int end = state.numConsumers + state.numNonConsumers - state.removed - neverCalled.size();
        for (int t = 0; t < end; ++t) {
            Future<IFileProcessorFutureResult> future = null;
            try {
                future = completionService.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("thread interrupt while polling in final shutdown loop");
                break;
            }
            logger.trace("In while future==null loop in final shutdown loop");
            if (future == null) break;
            try {
                IFileProcessorFutureResult result = future.get();
                if (result instanceof FileConsumerFutureResult) {
                    FileConsumerFutureResult consumerResult = (FileConsumerFutureResult)result;
                    FileStarted fileStarted = consumerResult.getFileStarted();
                    if (fileStarted == null || fileStarted.getElapsedMillis() <= this.timeoutThresholdMillis) continue;
                    logger.warn(fileStarted.getResourceId() + "\t caused a file processor to hang or crash. You may need to remove " + "this file from your input set and rerun.");
                    continue;
                }
                if (!(result instanceof FileResourceCrawlerFutureResult)) continue;
                FileResourceCrawlerFutureResult crawlerResult = (FileResourceCrawlerFutureResult)result;
                considered += crawlerResult.getConsidered();
                added += crawlerResult.getAdded();
                continue;
            }
            catch (ExecutionException e) {
                logger.error("Execution exception trying to shutdown after shutdownNow:" + e.getMessage());
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Interrupted exception trying to shutdown after shutdownNow:" + e.getMessage());
            }
        }
        String restartMsg = null;
        if (state.causeForTermination != CAUSE_FOR_TERMINATION.USER_INTERRUPTION && state.causeForTermination != CAUSE_FOR_TERMINATION.MAIN_LOOP_EXCEPTION_NO_RESTART) {
            if (state.causeForTermination == CAUSE_FOR_TERMINATION.MAIN_LOOP_EXCEPTION) {
                restartMsg = "Uncaught consumer throwable";
            } else if (state.causeForTermination == CAUSE_FOR_TERMINATION.TIMED_OUT_CONSUMER) {
                if (this.areResourcesPotentiallyRemaining()) {
                    restartMsg = "Consumer timed out with resources remaining";
                }
            } else if (state.causeForTermination == CAUSE_FOR_TERMINATION.BATCH_PROCESS_ALIVE_TOO_LONG) {
                restartMsg = BATCH_CONSTANTS.BATCH_PROCESS_EXCEEDED_MAX_ALIVE_TIME.toString();
            } else if (state.causeForTermination == CAUSE_FOR_TERMINATION.CRAWLER_TIMED_OUT) {
                restartMsg = "Crawler timed out.";
            } else if (this.fileResourceCrawler.wasTimedOut()) {
                restartMsg = "Crawler was timed out.";
            } else if (this.fileResourceCrawler.isActive()) {
                restartMsg = "Crawler is still active.";
            } else if (!this.fileResourceCrawler.isQueueEmpty()) {
                restartMsg = "Resources still exist for processing";
            }
        }
        int exitStatus = this.getExitStatus(state.causeForTermination, restartMsg);
        timeoutChecker.checkForTimedOutConsumers();
        for (FileStarted fs : this.timedOuts) {
            logger.warn("A parser was still working on >" + fs.getResourceId() + "< for " + fs.getElapsedMillis() + " milliseconds after it started." + " This exceeds the maxTimeoutMillis parameter");
        }
        double elapsed = ((double)new Date().getTime() - (double)state.start) / 1000.0;
        int processed = 0;
        int numExceptions = 0;
        for (FileResourceConsumer c : this.consumersManager.getConsumers()) {
            processed += c.getNumResourcesConsumed();
            numExceptions += c.getNumHandledExceptions();
        }
        return new ParallelFileProcessingResult(considered, added, processed, numExceptions, elapsed, exitStatus, state.causeForTermination.toString());
    }

    private void startConsumersManager() {
        if (this.consumersManagerMaxMillis < 0L) {
            this.consumersManager.init();
            return;
        }
        Thread timed = new Thread(){

            @Override
            public void run() {
                logger.trace("about to start consumers manager");
                BatchProcess.this.consumersManager.init();
                logger.trace("finished starting consumers manager");
            }
        };
        timed.setDaemon(true);
        timed.start();
        try {
            timed.join(this.consumersManagerMaxMillis);
        }
        catch (InterruptedException e) {
            logger.warn("interruption exception during consumers manager shutdown");
        }
        if (timed.isAlive()) {
            logger.error("ConsumersManager did not start within " + this.consumersManagerMaxMillis + "ms");
            throw new BatchNoRestartError("ConsumersManager did not start within " + this.consumersManagerMaxMillis + "ms");
        }
    }

    private void shutdownConsumersManager() {
        if (this.consumersManagerMaxMillis < 0L) {
            this.consumersManager.shutdown();
            return;
        }
        Thread timed = new Thread(){

            @Override
            public void run() {
                logger.trace("starting to shutdown consumers manager");
                BatchProcess.this.consumersManager.shutdown();
                logger.trace("finished shutting down consumers manager");
            }
        };
        timed.setDaemon(true);
        timed.start();
        try {
            timed.join(this.consumersManagerMaxMillis);
        }
        catch (InterruptedException e) {
            logger.warn("interruption exception during consumers manager shutdown");
        }
        if (timed.isAlive()) {
            logger.error("ConsumersManager was still alive during shutdown!");
            throw new BatchNoRestartError("ConsumersManager did not shutdown within: " + this.consumersManagerMaxMillis + "ms");
        }
    }

    private void politelyAwaitTermination(CAUSE_FOR_TERMINATION causeForTermination) {
        if (causeForTermination == CAUSE_FOR_TERMINATION.COMPLETED_NORMALLY) {
            return;
        }
        long start = new Date().getTime();
        while (this.countActiveConsumers() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.warn("Thread interrupted while trying to politelyAwaitTermination");
                return;
            }
            long elapsed = new Date().getTime() - start;
            if (this.pauseOnEarlyTerminationMillis <= -1L || elapsed <= this.pauseOnEarlyTerminationMillis) continue;
            logger.warn("I waited after an early termination for " + elapsed + ", but there was at least one active consumer");
            return;
        }
    }

    private boolean isNonRestart(Throwable e) {
        if (e instanceof BatchNoRestartError) {
            return true;
        }
        Throwable cause = e.getCause();
        return cause != null && this.isNonRestart(cause);
    }

    private int getExitStatus(CAUSE_FOR_TERMINATION causeForTermination, String restartMsg) {
        if (causeForTermination == CAUSE_FOR_TERMINATION.MAIN_LOOP_EXCEPTION_NO_RESTART) {
            logger.info(CAUSE_FOR_TERMINATION.MAIN_LOOP_EXCEPTION_NO_RESTART.name());
            return 254;
        }
        if (restartMsg != null) {
            if (restartMsg.equals(BATCH_CONSTANTS.BATCH_PROCESS_EXCEEDED_MAX_ALIVE_TIME.toString())) {
                logger.warn(restartMsg);
            } else {
                logger.error(restartMsg);
            }
            this.outputStreamWriter.println(BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString() + " >> " + restartMsg);
            this.outputStreamWriter.flush();
            return 253;
        }
        return 0;
    }

    private boolean areResourcesPotentiallyRemaining() {
        if (this.fileResourceCrawler.isActive()) {
            return true;
        }
        return !this.fileResourceCrawler.isQueueEmpty();
    }

    private boolean aliveTooLong(long started) {
        if (this.maxAliveTimeSeconds < 0) {
            return false;
        }
        double elapsedSeconds = (double)(new Date().getTime() - started) / 1000.0;
        return elapsedSeconds > (double)this.maxAliveTimeSeconds;
    }

    private int countActiveConsumers() {
        int active = 0;
        for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
            if (!consumer.isStillActive()) continue;
            ++active;
        }
        return active;
    }

    public void setPauseOnEarlyTerminationMillis(long pauseOnEarlyTerminationMillis) {
        this.pauseOnEarlyTerminationMillis = pauseOnEarlyTerminationMillis;
    }

    public void setTimeoutThresholdMillis(long timeoutThresholdMillis) {
        this.timeoutThresholdMillis = timeoutThresholdMillis;
    }

    public void setTimeoutCheckPulseMillis(long timeoutCheckPulseMillis) {
        this.timeoutCheckPulseMillis = timeoutCheckPulseMillis;
    }

    public void setMaxAliveTimeSeconds(int maxAliveTimeSeconds) {
        this.maxAliveTimeSeconds = maxAliveTimeSeconds;
    }

    private class TimeoutFutureResult
    implements IFileProcessorFutureResult {
        private final int timedOutCount;

        private TimeoutFutureResult(int timedOutCount) {
            this.timedOutCount = timedOutCount;
        }

        protected int getTimedOutCount() {
            return this.timedOutCount;
        }
    }

    private class TimeoutChecker
    implements Callable<IFileProcessorFutureResult> {
        private TimeoutChecker() {
        }

        @Override
        public TimeoutFutureResult call() throws Exception {
            while (BatchProcess.this.timedOuts.size() == 0) {
                try {
                    Thread.sleep(BatchProcess.this.timeoutCheckPulseMillis);
                }
                catch (InterruptedException e) {
                    logger.debug("Thread interrupted exception in TimeoutChecker");
                    break;
                }
                this.checkForTimedOutConsumers();
                if (BatchProcess.this.countActiveConsumers() != 0) continue;
                logger.info("No activeConsumers in TimeoutChecker");
                break;
            }
            logger.debug("TimeoutChecker quitting: " + BatchProcess.this.timedOuts.size());
            return new TimeoutFutureResult(BatchProcess.this.timedOuts.size());
        }

        private void checkForTimedOutConsumers() {
            for (FileResourceConsumer consumer : BatchProcess.this.consumersManager.getConsumers()) {
                FileStarted fs = consumer.checkForTimedOutMillis(BatchProcess.this.timeoutThresholdMillis);
                if (fs == null) continue;
                BatchProcess.this.timedOuts.add(fs);
            }
        }
    }

    private class State {
        long start = -1L;
        int numConsumers = 0;
        int numNonConsumers = 0;
        int removed = 0;
        int consumersRemoved = 0;
        int crawlersRemoved = 0;
        CAUSE_FOR_TERMINATION causeForTermination = null;

        private State() {
        }
    }

    private static enum CAUSE_FOR_TERMINATION {
        COMPLETED_NORMALLY,
        MAIN_LOOP_EXCEPTION_NO_RESTART,
        CONSUMERS_MANAGER_DIDNT_INIT_IN_TIME_NO_RESTART,
        MAIN_LOOP_EXCEPTION,
        CRAWLER_TIMED_OUT,
        TIMED_OUT_CONSUMER,
        USER_INTERRUPTION,
        BATCH_PROCESS_ALIVE_TOO_LONG;

    }

    public static enum BATCH_CONSTANTS {
        BATCH_PROCESS_EXCEEDED_MAX_ALIVE_TIME,
        BATCH_PROCESS_FATAL_MUST_RESTART;

    }
}

