/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessDriverCLI {
    public static final int PROCESS_RESTART_EXIT_CODE = 253;
    public static final int PROCESS_NO_RESTART_EXIT_CODE = 254;
    public static final int PROCESS_COMPLETED_SUCCESSFULLY = 0;
    private static Logger logger = LoggerFactory.getLogger(BatchProcessDriverCLI.class);
    private int maxProcessRestarts = -1;
    private long pulseMillis = 1000L;
    private int waitNumLoopsAfterRestartmessage = 60;
    int loopsAfterRestartMessageReceived = 0;
    private volatile boolean userInterrupted = false;
    private boolean receivedRestartMsg = false;
    private Process process = null;
    private StreamGobbler errorWatcher = null;
    private StreamGobbler outGobbler = null;
    private InterruptWriter interruptWriter = null;
    private final InterruptWatcher interruptWatcher = new InterruptWatcher(System.in);
    private Thread errorWatcherThread = null;
    private Thread outGobblerThread = null;
    private Thread interruptWriterThread = null;
    private final Thread interruptWatcherThread = new Thread(this.interruptWatcher);
    private final String[] commandLine;
    private int numRestarts = 0;
    private boolean redirectChildProcessToStdOut = true;

    public BatchProcessDriverCLI(String[] commandLine) {
        this.commandLine = this.tryToReadMaxRestarts(commandLine);
    }

    private String[] tryToReadMaxRestarts(String[] commandLine) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < commandLine.length; ++i) {
            String arg = commandLine[i];
            if (arg.equals("-maxRestarts")) {
                if (i == commandLine.length - 1) {
                    throw new IllegalArgumentException("Must specify an integer after \"-maxRestarts\"");
                }
                String restartNumString = commandLine[i + 1];
                try {
                    this.maxProcessRestarts = Integer.parseInt(restartNumString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Must specify an integer after \"-maxRestarts\" arg.");
                }
                ++i;
                continue;
            }
            args.add(arg);
        }
        return args.toArray(new String[args.size()]);
    }

    public void execute() throws Exception {
        this.interruptWatcherThread.setDaemon(true);
        this.interruptWatcherThread.start();
        logger.info("about to start driver");
        this.start();
        while (!this.userInterrupted) {
            Integer exit = null;
            try {
                logger.trace("about to check exit value");
                exit = this.process.exitValue();
                logger.info("The child process has finished with an exit value of: " + exit);
                this.stop();
            }
            catch (IllegalThreadStateException e) {
                logger.trace("process has not exited; IllegalThreadStateException");
            }
            logger.trace("Before sleep: exit=" + exit + " receivedRestartMsg=" + this.receivedRestartMsg);
            try {
                Thread.sleep(this.pulseMillis);
            }
            catch (InterruptedException e) {
                logger.trace("interrupted exception during sleep");
            }
            logger.trace("After sleep: exit=" + exit + " receivedRestartMsg=" + this.receivedRestartMsg);
            if (this.receivedRestartMsg && exit == null && this.loopsAfterRestartMessageReceived <= this.waitNumLoopsAfterRestartmessage) {
                ++this.loopsAfterRestartMessageReceived;
                logger.warn("Must restart, still not exited; loops after restart: " + this.loopsAfterRestartMessageReceived);
                continue;
            }
            if (this.loopsAfterRestartMessageReceived > this.waitNumLoopsAfterRestartmessage) {
                logger.trace("About to try to restart because: exit=" + exit + " receivedRestartMsg=" + this.receivedRestartMsg);
                logger.warn("Restarting after exceeded wait loops waiting for exit: " + this.loopsAfterRestartMessageReceived);
                boolean restarted = this.restart(exit, this.receivedRestartMsg);
                if (restarted) continue;
                break;
            }
            if (exit != null && exit != 254 && exit != 0) {
                boolean restarted;
                logger.trace("About to try to restart because: exit=" + exit + " receivedRestartMsg=" + this.receivedRestartMsg);
                if (exit == 253) {
                    logger.info("Restarting on expected restart code");
                } else {
                    logger.warn("Restarting on unexpected restart code: " + exit);
                }
                if (restarted = this.restart(exit, this.receivedRestartMsg)) continue;
                break;
            }
            if (exit == null || exit != 0 && exit != 254) continue;
            logger.trace("Will not restart: " + exit);
            break;
        }
        logger.trace("about to call shutdown driver now");
        this.shutdownDriverNow();
        logger.info("Process driver has completed");
    }

    private void shutdownDriverNow() {
        if (this.process != null) {
            for (int i = 0; i < 60; ++i) {
                logger.trace("trying to shut down: " + i);
                try {
                    int exit = this.process.exitValue();
                    logger.trace("trying to stop:" + exit);
                    this.stop();
                    this.interruptWatcherThread.interrupt();
                    return;
                }
                catch (IllegalThreadStateException e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            logger.error("Process didn't stop after 60 seconds after shutdown. I am forcefully killing it.");
        }
        this.interruptWatcherThread.interrupt();
    }

    public int getNumRestarts() {
        return this.numRestarts;
    }

    public boolean getUserInterrupted() {
        return this.userInterrupted;
    }

    private boolean restart(Integer exitValue, boolean receivedRestartMsg) throws Exception {
        if (this.maxProcessRestarts > -1 && this.numRestarts >= this.maxProcessRestarts) {
            logger.warn("Hit the maximum number of process restarts. Driver is shutting down now.");
            this.stop();
            return false;
        }
        logger.warn("Must restart process (exitValue=" + exitValue + " numRestarts=" + this.numRestarts + " receivedRestartMessage=" + receivedRestartMsg + ")");
        this.stop();
        this.start();
        ++this.numRestarts;
        this.loopsAfterRestartMessageReceived = 0;
        return true;
    }

    private void stop() {
        if (this.process != null) {
            logger.trace("destroying a non-null process");
            this.process.destroy();
        }
        this.receivedRestartMsg = false;
        this.interruptWriterThread.interrupt();
        this.errorWatcher.stopGobblingAndDie();
        this.outGobbler.stopGobblingAndDie();
        this.errorWatcherThread.interrupt();
        this.outGobblerThread.interrupt();
    }

    private void start() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(this.commandLine);
        builder.directory(new File("."));
        this.process = builder.start();
        this.errorWatcher = new StreamWatcher(this.process.getErrorStream());
        this.errorWatcherThread = new Thread(this.errorWatcher);
        this.errorWatcherThread.start();
        this.outGobbler = new StreamGobbler(this.process.getInputStream());
        this.outGobblerThread = new Thread(this.outGobbler);
        this.outGobblerThread.start();
        this.interruptWriter = new InterruptWriter(this.process.getOutputStream());
        this.interruptWriterThread = new Thread(this.interruptWriter);
        this.interruptWriterThread.start();
    }

    public void setRedirectChildProcessToStdOut(boolean redirectChildProcessToStdOut) {
        this.redirectChildProcessToStdOut = redirectChildProcessToStdOut;
    }

    public static void main(String[] args) throws Exception {
        BatchProcessDriverCLI runner = new BatchProcessDriverCLI(args);
        runner.execute();
        System.out.println("FSBatchProcessDriver has gracefully completed");
        System.exit(0);
    }

    private class StreamWatcher
    extends StreamGobbler
    implements Runnable {
        private StreamWatcher(InputStream is) {
            super(is);
        }

        @Override
        public void run() {
            String line = null;
            try {
                logger.trace("watcher starting to read");
                while ((line = this.reader.readLine()) != null && this.running) {
                    if (line.startsWith(BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString())) {
                        BatchProcessDriverCLI.this.receivedRestartMsg = true;
                    }
                    logger.info("BatchProcess: " + line);
                }
            }
            catch (IOException e) {
                logger.trace("watcher io exception");
            }
            logger.trace("watcher done");
        }
    }

    private class StreamGobbler
    implements Runnable {
        protected final BufferedReader reader;
        protected boolean running = true;

        private StreamGobbler(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(is), IOUtils.UTF_8));
        }

        @Override
        public void run() {
            String line = null;
            try {
                logger.trace("gobbler starting to read");
                while ((line = this.reader.readLine()) != null && this.running) {
                    if (!BatchProcessDriverCLI.this.redirectChildProcessToStdOut) continue;
                    System.out.println("BatchProcess:" + line);
                }
            }
            catch (IOException e) {
                logger.trace("gobbler io exception");
            }
            logger.trace("gobbler done");
        }

        private void stopGobblingAndDie() {
            logger.trace("stop gobbling");
            this.running = false;
            IOUtils.closeQuietly((Reader)this.reader);
        }
    }

    private class InterruptWriter
    implements Runnable {
        private final Writer writer;

        private InterruptWriter(OutputStream os) {
            this.writer = new OutputStreamWriter(os, IOUtils.UTF_8);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                    if (!BatchProcessDriverCLI.this.userInterrupted) continue;
                    this.writer.write(String.format(Locale.ENGLISH, "Ave atque vale!%n", new Object[0]));
                    this.writer.flush();
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class InterruptWatcher
    implements Runnable {
        private BufferedReader reader;

        private InterruptWatcher(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is, IOUtils.UTF_8));
        }

        @Override
        public void run() {
            try {
                this.reader.readLine();
                BatchProcessDriverCLI.this.userInterrupted = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

