/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.builders;

import java.util.Locale;
import java.util.Map;
import org.apache.tika.batch.builders.IContentHandlerFactoryBuilder;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.util.XMLDOMUtil;
import org.w3c.dom.Node;

public class DefaultContentHandlerFactoryBuilder
implements IContentHandlerFactoryBuilder {
    @Override
    public ContentHandlerFactory build(Node node, Map<String, String> runtimeAttributes) {
        Map<String, String> attributes = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        BasicContentHandlerFactory.HANDLER_TYPE type = null;
        String handlerTypeString = attributes.get("basicHandlerType");
        if (handlerTypeString == null) {
            handlerTypeString = "text";
        }
        type = (handlerTypeString = handlerTypeString.toLowerCase(Locale.ROOT)).equals("xml") ? BasicContentHandlerFactory.HANDLER_TYPE.XML : (handlerTypeString.equals("text") ? BasicContentHandlerFactory.HANDLER_TYPE.TEXT : (handlerTypeString.equals("txt") ? BasicContentHandlerFactory.HANDLER_TYPE.TEXT : (handlerTypeString.equals("html") ? BasicContentHandlerFactory.HANDLER_TYPE.HTML : (handlerTypeString.equals("body") ? BasicContentHandlerFactory.HANDLER_TYPE.BODY : (handlerTypeString.equals("ignore") ? BasicContentHandlerFactory.HANDLER_TYPE.IGNORE : BasicContentHandlerFactory.HANDLER_TYPE.TEXT)))));
        int writeLimit = -1;
        String writeLimitString = attributes.get("writeLimit");
        if (writeLimitString != null) {
            try {
                writeLimit = Integer.parseInt(attributes.get("writeLimit"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new BasicContentHandlerFactory(type, writeLimit);
    }
}

