/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.fs.FSFileResource;
import org.apache.tika.batch.fs.FSUtil;

public class FSDirectoryCrawler
extends FileResourceCrawler {
    private final File root;
    private final File startDirectory;
    private final Comparator<File> fileComparator = new FileNameComparator();
    private CRAWL_ORDER crawlOrder;

    public FSDirectoryCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, File root, CRAWL_ORDER crawlOrder) {
        super(fileQueue, numConsumers);
        this.root = root;
        this.startDirectory = root;
        this.crawlOrder = crawlOrder;
        if (!this.startDirectory.isDirectory()) {
            throw new RuntimeException("Crawler couldn't find this directory:" + this.startDirectory.getAbsolutePath());
        }
    }

    public FSDirectoryCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, File root, File startDirectory, CRAWL_ORDER crawlOrder) {
        super(fileQueue, numConsumers);
        this.root = root;
        this.startDirectory = startDirectory;
        this.crawlOrder = crawlOrder;
        assert (FSUtil.checkThisIsAncestorOfOrSameAsThat(root, startDirectory));
        if (!startDirectory.isDirectory()) {
            throw new RuntimeException("Crawler couldn't find this directory:" + startDirectory.getAbsolutePath());
        }
    }

    @Override
    public void start() throws InterruptedException {
        this.addFiles(this.startDirectory);
    }

    private void addFiles(File directory) throws InterruptedException {
        if (directory == null || !directory.isDirectory() || !directory.canRead()) {
            String path = "null path";
            if (directory != null) {
                path = directory.getAbsolutePath();
            }
            logger.warn("FSFileAdder can't read this directory: " + path);
            return;
        }
        ArrayList<File> directories = new ArrayList<File>();
        File[] fileArr = directory.listFiles();
        if (fileArr == null) {
            logger.info("Empty directory: " + directory.getAbsolutePath());
            return;
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(fileArr));
        if (this.crawlOrder == CRAWL_ORDER.RANDOM) {
            Collections.shuffle(files);
        } else if (this.crawlOrder == CRAWL_ORDER.SORTED) {
            Collections.sort(files, this.fileComparator);
        }
        int numFiles = 0;
        for (File f : files) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("file adder interrupted");
            }
            if (f.isFile() && ++numFiles == 1) {
                this.handleFirstFileInDirectory(f);
            }
            if (f.isDirectory()) {
                directories.add(f);
                continue;
            }
            int added = this.tryToAdd(new FSFileResource(this.root, f));
            if (added == 2) {
                logger.debug("crawler has hit a limit: " + f.getAbsolutePath() + " : " + added);
                return;
            }
            logger.debug("trying to add: " + f.getAbsolutePath() + " : " + added);
        }
        for (File f : directories) {
            this.addFiles(f);
        }
    }

    public void handleFirstFileInDirectory(File f) {
    }

    private class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == null || f2 == null) {
                return 0;
            }
            return f1.getName().compareTo(f2.getName());
        }
    }

    public static enum CRAWL_ORDER {
        SORTED,
        RANDOM,
        OS_ORDER;

    }
}

