/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.batch.fs.FSUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;

public class FSFileResource
implements FileResource {
    private final File fullPath;
    private final String relativePath;
    private final Metadata metadata;

    public FSFileResource(File inputRoot, File fullPath) {
        this.fullPath = fullPath;
        this.metadata = new Metadata();
        assert (FSUtil.checkThisIsAncestorOfThat(inputRoot, fullPath));
        this.relativePath = fullPath.getAbsolutePath().substring(inputRoot.getAbsolutePath().length() + 1);
        this.metadata.set("resourceName", fullPath.getName());
        this.metadata.set("Content-Length", Long.toString(fullPath.length()));
        this.metadata.set(FSProperties.FS_REL_PATH, this.relativePath);
        this.metadata.set(FileResource.FILE_EXTENSION, this.getExtension(fullPath));
    }

    private String getExtension(File fullPath) {
        String p = fullPath.getName();
        int i = p.lastIndexOf(".");
        if (i > -1) {
            return p.substring(i + 1).toLowerCase(Locale.ROOT);
        }
        return "";
    }

    @Override
    public String getResourceId() {
        return this.relativePath;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return TikaInputStream.get((File)this.fullPath);
    }
}

