/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.fs.FSFileResource;

public class FSListCrawler
extends FileResourceCrawler {
    private final BufferedReader reader;
    private final File root;

    public FSListCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, File root, File list, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileQueue, numConsumers);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(list), encoding));
        this.root = root;
    }

    @Override
    public void start() throws InterruptedException {
        String line = this.nextLine();
        while (line != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("file adder interrupted");
            }
            File f = new File(this.root, line);
            if (!f.exists()) {
                logger.warn("File doesn't exist:" + f.getAbsolutePath());
                line = this.nextLine();
                continue;
            }
            if (f.isDirectory()) {
                logger.warn("File is a directory:" + f.getAbsolutePath());
                line = this.nextLine();
                continue;
            }
            this.tryToAdd(new FSFileResource(this.root, f));
            line = this.nextLine();
        }
    }

    private String nextLine() {
        String line = null;
        try {
            line = this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return line;
    }
}

