/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.batch.fs.FSUtil;
import org.apache.tika.metadata.Metadata;

public class FSOutputStreamFactory
implements OutputStreamFactory {
    private final FSUtil.HANDLE_EXISTING handleExisting;
    private final File outputRoot;
    private final String suffix;
    private final COMPRESSION compression;

    public FSOutputStreamFactory(File outputRoot, FSUtil.HANDLE_EXISTING handleExisting, COMPRESSION compression, String suffix) {
        this.handleExisting = handleExisting;
        this.outputRoot = outputRoot.getAbsoluteFile();
        this.suffix = suffix;
        this.compression = compression;
    }

    @Override
    public OutputStream getOutputStream(Metadata metadata) throws IOException {
        boolean success;
        String initialRelativePath = metadata.get(FSProperties.FS_REL_PATH);
        File outputFile = FSUtil.getOutputFile(this.outputRoot, initialRelativePath, this.handleExisting, this.suffix);
        if (outputFile == null) {
            return null;
        }
        if (!(outputFile.getParentFile().isDirectory() || (success = outputFile.getParentFile().mkdirs()) || outputFile.getParentFile().isDirectory())) {
            throw new IOException("Couldn't create parent directory for:" + outputFile.getAbsolutePath());
        }
        OutputStream os = new FileOutputStream(outputFile);
        if (this.compression == COMPRESSION.BZIP2) {
            os = new BZip2CompressorOutputStream(os);
        } else if (this.compression == COMPRESSION.GZIP) {
            os = new GZIPOutputStream(os);
        } else if (this.compression == COMPRESSION.ZIP) {
            os = new ZipArchiveOutputStream(os);
        }
        return os;
    }

    public static enum COMPRESSION {
        NONE,
        BZIP2,
        GZIP,
        ZIP;

    }
}

