/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FSUtil {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("\\A(.*?)(?:\\((\\d+)\\))?\\.([^\\.]+)\\Z");

    public static boolean checkThisIsAncestorOfThat(File ancestor, File child) {
        int ancLen = ancestor.getAbsolutePath().length();
        int childLen = child.getAbsolutePath().length();
        if (childLen <= ancLen) {
            return false;
        }
        String childBase = child.getAbsolutePath().substring(0, ancLen);
        return childBase.equals(ancestor.getAbsolutePath());
    }

    public static boolean checkThisIsAncestorOfOrSameAsThat(File ancestor, File child) {
        if (ancestor.equals(child)) {
            return true;
        }
        return FSUtil.checkThisIsAncestorOfThat(ancestor, child);
    }

    public static File getOutputFile(File outputRoot, String initialRelativePath, HANDLE_EXISTING handleExisting, String suffix) throws IOException {
        String localSuffix = suffix == null ? "" : suffix;
        File cand = new File(outputRoot, initialRelativePath + "." + localSuffix);
        if (cand.isFile()) {
            if (handleExisting.equals((Object)HANDLE_EXISTING.OVERWRITE)) {
                return cand;
            }
            if (handleExisting.equals((Object)HANDLE_EXISTING.SKIP)) {
                return null;
            }
        }
        int cnt = 0;
        String fNameBase = null;
        String fNameExt = "";
        File candOnly = new File(outputRoot, initialRelativePath);
        Matcher m = FILE_NAME_PATTERN.matcher(candOnly.getName());
        if (m.find()) {
            fNameBase = m.group(1);
            if (m.group(2) != null) {
                try {
                    cnt = Integer.parseInt(m.group(2));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (m.group(3) != null) {
                fNameExt = m.group(3);
            }
        }
        File outputParent = cand.getParentFile();
        while (fNameBase != null && cand.isFile() && ++cnt < 10000) {
            String candFileName = fNameBase + "(" + cnt + ")." + fNameExt + "" + localSuffix;
            cand = new File(outputParent, candFileName);
        }
        cnt = 0;
        while (cand.isFile() && cnt++ < 20000) {
            UUID uid = UUID.randomUUID();
            cand = new File(outputParent, uid.toString() + fNameExt + "" + localSuffix);
        }
        if (cand.isFile()) {
            throw new IOException("Couldn't find candidate output file after trying very, very hard");
        }
        return cand;
    }

    public static enum HANDLE_EXISTING {
        OVERWRITE,
        RENAME,
        SKIP;

    }
}

