/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs.strawman;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class StrawManTikaAppDriver
implements Callable<Integer> {
    private static AtomicInteger threadCount = new AtomicInteger(0);
    private final int totalThreads;
    private final int threadNum;
    private int rootLen = -1;
    private File inputDir = null;
    private File outputDir = null;
    private String[] args = null;
    private Logger logger = LoggerFactory.getLogger(StrawManTikaAppDriver.class);

    public StrawManTikaAppDriver(File inputDir, File outputDir, int totalThreads, String[] args) {
        this.rootLen = inputDir.getAbsolutePath().length() + 1;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.args = args;
        this.threadNum = threadCount.getAndIncrement();
        this.totalThreads = totalThreads;
    }

    private int processDirectory(File inputDir) {
        int processed = 0;
        if (inputDir == null || inputDir.listFiles() == null) {
            return processed;
        }
        for (File f : inputDir.listFiles()) {
            ArrayList<File> childDirs = new ArrayList<File>();
            if (f.isDirectory()) {
                childDirs.add(f);
            } else {
                processed += this.processFile(f);
            }
            for (File dir : childDirs) {
                processed += this.processDirectory(dir);
            }
        }
        return processed;
    }

    private int processFile(File f) {
        int hashCode;
        if (this.totalThreads > 1 && Math.abs((hashCode = f.getAbsolutePath().hashCode()) % this.totalThreads) != this.threadNum) {
            return 0;
        }
        File outputFile = new File(this.outputDir, f.getAbsolutePath().substring(this.rootLen) + ".txt");
        outputFile.getAbsoluteFile().getParentFile().mkdirs();
        if (!outputFile.getParentFile().exists()) {
            this.logger.error(MarkerFactory.getMarker((String)"FATAL"), "parent directory for " + outputFile + " was not made!");
            throw new RuntimeException("couldn't make parent file for " + outputFile);
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        for (String arg : this.args) {
            commandLine.add(arg);
        }
        commandLine.add("-t");
        commandLine.add("\"" + f.getAbsolutePath() + "\"");
        ProcessBuilder builder = new ProcessBuilder(commandLine.toArray(new String[commandLine.size()]));
        this.logger.info("about to process: " + f.getAbsolutePath());
        Process proc = null;
        RedirectGobbler gobbler = null;
        Thread gobblerThread = null;
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            proc = builder.start();
            gobbler = new RedirectGobbler(proc.getInputStream(), os);
            gobblerThread = new Thread(gobbler);
            gobblerThread.start();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return 0;
        }
        boolean finished = false;
        long totalTime = 180000L;
        long pulse = 100L;
        int i = 0;
        while ((long)i < totalTime) {
            try {
                Thread.currentThread();
                Thread.sleep(pulse);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                int exit = proc.exitValue();
                finished = true;
                break;
            }
            catch (IllegalThreadStateException e) {
                i = (int)((long)i + pulse);
            }
        }
        if (!finished) {
            this.logger.warn("Had to kill process working on: " + f.getAbsolutePath());
            proc.destroy();
        }
        gobbler.close();
        gobblerThread.interrupt();
        return 1;
    }

    @Override
    public Integer call() throws Exception {
        long start = new Date().getTime();
        int processed = this.processDirectory(this.inputDir);
        double elapsedSecs = ((double)new Date().getTime() - (double)start) / 1000.0;
        this.logger.info("Finished processing " + processed + " files in " + elapsedSecs + " seconds.");
        return processed;
    }

    public static String usage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Example usage:\n");
        sb.append("java -cp <CP> org.apache.batch.fs.strawman.StrawManTikaAppDriver ");
        sb.append("<inputDir> <outputDir> <numThreads> ");
        sb.append("java -jar tika-app-X.Xjar <...commandline arguments for tika-app>\n\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        long start = new Date().getTime();
        if (args.length < 6) {
            System.err.println(StrawManTikaAppDriver.usage());
        }
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        int totalThreads = Integer.parseInt(args[2]);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(Arrays.asList(args).subList(3, args.length));
        totalThreads = totalThreads < 1 ? 1 : totalThreads;
        ExecutorService ex = Executors.newFixedThreadPool(totalThreads);
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(ex);
        for (int i = 0; i < totalThreads; ++i) {
            StrawManTikaAppDriver driver = new StrawManTikaAppDriver(inputDir, outputDir, totalThreads, commandLine.toArray(new String[commandLine.size()]));
            completionService.submit(driver);
        }
        int totalFilesProcessed = 0;
        for (int i = 0; i < totalThreads; ++i) {
            try {
                Future future = completionService.take();
                if (future == null) continue;
                totalFilesProcessed += ((Integer)future.get()).intValue();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        double elapsedSeconds = (double)(new Date().getTime() - start) / 1000.0;
        System.out.println("Processed " + totalFilesProcessed + " in " + elapsedSeconds + " seconds");
    }

    private class RedirectGobbler
    implements Runnable {
        private OutputStream redirectOs = null;
        private InputStream redirectIs = null;

        private RedirectGobbler(InputStream is, OutputStream os) {
            this.redirectIs = is;
            this.redirectOs = os;
        }

        private void close() {
            if (this.redirectOs != null) {
                try {
                    this.redirectOs.flush();
                }
                catch (IOException e) {
                    StrawManTikaAppDriver.this.logger.error("can't flush");
                }
                try {
                    this.redirectIs.close();
                }
                catch (IOException e) {
                    StrawManTikaAppDriver.this.logger.error("can't close input in redirect gobbler");
                }
                try {
                    this.redirectOs.close();
                }
                catch (IOException e) {
                    StrawManTikaAppDriver.this.logger.error("can't close output in redirect gobbler");
                }
            }
        }

        @Override
        public void run() {
            try {
                IOUtils.copy((InputStream)this.redirectIs, (OutputStream)this.redirectOs);
            }
            catch (IOException e) {
                StrawManTikaAppDriver.this.logger.error("IOException while gobbling");
            }
        }
    }
}

