/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;

@XmlType(name="GeodeticCRSType", propOrder={"ellipsoidalCS", "cartesianCS", "sphericalCS", "datum"})
@XmlRootElement(name="GeodeticCRS")
class DefaultGeodeticCRS
extends AbstractCRS
implements GeodeticCRS {
    private static final long serialVersionUID = -6205678223972395910L;
    @XmlElement(name="geodeticDatum")
    private final GeodeticDatum datum;

    DefaultGeodeticCRS() {
        this.datum = null;
    }

    DefaultGeodeticCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CoordinateSystem coordinateSystem) {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull("datum", geodeticDatum);
        this.datum = geodeticDatum;
    }

    protected DefaultGeodeticCRS(GeodeticCRS geodeticCRS) {
        super(geodeticCRS);
        this.datum = geodeticCRS.getDatum();
    }

    public Class<? extends GeodeticCRS> getInterface() {
        return GeodeticCRS.class;
    }

    @Override
    public GeodeticDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    @XmlElement(name="ellipsoidalCS")
    private EllipsoidalCS getEllipsoidalCS() {
        return this.getCoordinateSystem(EllipsoidalCS.class);
    }

    private void setCartesianCS(CartesianCS cartesianCS) {
        super.setCoordinateSystem("cartesianCS", cartesianCS);
    }

    private void setSphericalCS(SphericalCS sphericalCS) {
        super.setCoordinateSystem("sphericalCS", sphericalCS);
    }

    private void setEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super.setCoordinateSystem("ellipsoidalCS", ellipsoidalCS);
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultGeodeticCRS(map, this.datum, coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this, formatter, null);
        boolean bl = formatter.getConvention().majorVersion() == 1;
        Unit<?> unit = this.getUnit();
        Unit<?> unit2 = formatter.addContextualUnit(unit);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.datum));
        formatter.newLine();
        formatter.indent(bl ? 0 : 1);
        formatter.append(WKTUtilities.toFormattable(this.datum.getPrimeMeridian()));
        formatter.indent(bl ? 0 : -1);
        formatter.newLine();
        CoordinateSystem coordinateSystem = super.getCoordinateSystem();
        if (bl) {
            formatter.append(unit);
            if (unit == null) {
                formatter.setInvalidWKT(this, null);
            }
            if (!(coordinateSystem instanceof EllipsoidalCS)) {
                if (coordinateSystem instanceof CartesianCS) {
                    coordinateSystem = Legacy.forGeocentricCRS((CartesianCS)coordinateSystem, true);
                } else {
                    formatter.setInvalidWKT(coordinateSystem, null);
                }
            }
        } else {
            formatter.append(WKTUtilities.toFormattable(coordinateSystem));
            formatter.indent(1);
        }
        int n = coordinateSystem.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(coordinateSystem.getAxis(i)));
        }
        if (!bl) {
            formatter.newLine();
            formatter.append(unit);
            formatter.indent(-1);
        }
        formatter.removeContextualUnit(unit);
        formatter.addContextualUnit(unit2);
        formatter.newLine();
        if (!bl) {
            return "GeodeticCRS";
        }
        return coordinateSystem instanceof EllipsoidalCS ? "GeogCS" : "GeocCS";
    }
}

