/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class LinearTransform1D
extends AbstractMathTransform1D
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -7595037195668813000L;
    final double scale;
    final double offset;
    private transient MathTransform1D inverse;

    protected LinearTransform1D(double d, double d2) {
        this.scale = d;
        this.offset = d2;
    }

    public static LinearTransform1D create(double d, double d2) {
        if (d2 == 0.0 && d == 1.0) {
            return IdentityTransform1D.INSTANCE;
        }
        if (d == 0.0) {
            if (d2 == 0.0) {
                return ConstantTransform1D.ZERO;
            }
            if (d2 == 1.0) {
                return ConstantTransform1D.ONE;
            }
            return new ConstantTransform1D(d2);
        }
        return new LinearTransform1D(d, d2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return TensorParameters.WKT1.createValueGroup(Affine.IDENTIFICATION, this.getMatrix());
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix2(this.scale, this.offset, 0.0, 1.0);
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.scale != 0.0) {
                LinearTransform1D linearTransform1D = LinearTransform1D.create(1.0 / this.scale, -this.offset / this.scale);
                linearTransform1D.inverse = this;
                this.inverse = linearTransform1D;
            } else {
                this.inverse = super.inverse();
            }
        }
        return this.inverse;
    }

    @Override
    public boolean isIdentity() {
        return this.offset == 0.0 && this.scale == 1.0;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        return new Matrix1(this.scale);
    }

    @Override
    public double derivative(double d) {
        return this.scale;
    }

    @Override
    public double transform(double d) {
        return this.offset + this.scale * d;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        if (dArray2 != null) {
            dArray2[n2] = this.offset + this.scale * dArray[n];
        }
        return bl ? new Matrix1(this.scale) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = this.offset + this.scale * dArray[n++];
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = this.offset + this.scale * dArray[--n];
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(this.offset + this.scale * (double)fArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(this.offset + this.scale * (double)fArray[--n]);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            fArray[n2++] = (float)(this.offset + this.scale * dArray[n++]);
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            dArray[n2++] = this.offset + this.scale * (double)fArray[n++];
        }
    }

    @Override
    protected int computeHashCode() {
        return Numerics.hashCode(Double.doubleToRawLongBits(this.offset) + 31L * Double.doubleToRawLongBits(this.scale)) ^ super.computeHashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (comparisonMode != ComparisonMode.STRICT) {
            if (object instanceof LinearTransform) {
                return Matrices.equals(this.getMatrix(), ((LinearTransform)object).getMatrix(), comparisonMode);
            }
        } else if (super.equals(object, comparisonMode)) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)object;
            return Double.doubleToRawLongBits(this.scale) == Double.doubleToRawLongBits(linearTransform1D.scale) && Double.doubleToRawLongBits(this.offset) == Double.doubleToRawLongBits(linearTransform1D.offset);
        }
        return false;
    }
}

