/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Temperature;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Scalar;
import org.apache.sis.util.ArgumentChecks;

class DerivedScalar<Q extends Quantity<Q>>
extends Scalar<Q> {
    private static final long serialVersionUID = 3729159568163676568L;
    private final double derivedValue;
    private final Unit<Q> derivedUnit;
    private final UnitConverter fromSystem;

    DerivedScalar(double d, Unit<Q> unit, Unit<Q> unit2, UnitConverter unitConverter) {
        super(unitConverter.convert(d), unit2);
        this.derivedValue = d;
        this.derivedUnit = unit;
        this.fromSystem = unitConverter.inverse();
    }

    DerivedScalar(DerivedScalar<Q> derivedScalar, double d) {
        super(d, derivedScalar.getSystemUnit());
        this.derivedUnit = derivedScalar.derivedUnit;
        this.fromSystem = derivedScalar.fromSystem;
        this.derivedValue = this.fromSystem.convert(d);
    }

    @Override
    Quantity<Q> create(double d, Unit<Q> unit) {
        assert (unit == this.getSystemUnit()) : unit;
        return new DerivedScalar<Q>(this, d);
    }

    final Unit<Q> getSystemUnit() {
        return super.getUnit();
    }

    @Override
    public final Unit<Q> getUnit() {
        return this.derivedUnit;
    }

    @Override
    public final double doubleValue() {
        return this.derivedValue;
    }

    @Override
    public final float floatValue() {
        return (float)this.derivedValue;
    }

    @Override
    public final long longValue() {
        return Math.round(this.derivedValue);
    }

    @Override
    public final Quantity<Q> to(Unit<Q> unit) {
        if (unit == this.derivedUnit) {
            return this;
        }
        ArgumentChecks.ensureNonNull("unit", unit);
        return Quantities.create(this.derivedUnit.getConverterTo(unit).convert(this.derivedValue), unit);
    }

    static final class Fallback<Q extends Quantity<Q>>
    extends DerivedScalar<Q>
    implements InvocationHandler {
        private final Class<Q> type;

        private Fallback(double d, Unit<Q> unit, Unit<Q> unit2, UnitConverter unitConverter, Class<Q> clazz) {
            super(d, unit, unit2, unitConverter);
            this.type = clazz;
        }

        private Fallback(Fallback<Q> fallback, double d) {
            super(fallback, d);
            this.type = fallback.type;
        }

        @Override
        Quantity<Q> create(double d, Unit<Q> unit) {
            assert (unit == this.getSystemUnit()) : unit;
            Fallback<Q> fallback = new Fallback<Q>(this, d);
            return (Quantity)Proxy.newProxyInstance(Scalar.class.getClassLoader(), new Class[]{this.type}, fallback);
        }

        static <Q extends Quantity<Q>> Q factory(double d, Unit<Q> unit, Unit<Q> unit2, UnitConverter unitConverter, Class<Q> clazz) {
            Fallback<Q> fallback = new Fallback<Q>(d, unit, unit2, unitConverter, clazz);
            return (Q)((Quantity)Proxy.newProxyInstance(Scalar.class.getClassLoader(), new Class[]{clazz}, fallback));
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws ReflectiveOperationException {
            return method.invoke((Object)this, objectArray);
        }
    }

    static final class TemperatureMeasurement
    extends DerivedScalar<Temperature>
    implements Temperature {
        private static final long serialVersionUID = -3901877967613695897L;

        TemperatureMeasurement(double d, Unit<Temperature> unit, Unit<Temperature> unit2, UnitConverter unitConverter) {
            super(d, unit, unit2, unitConverter);
        }

        private TemperatureMeasurement(TemperatureMeasurement temperatureMeasurement, double d) {
            super(temperatureMeasurement, d);
        }

        @Override
        Quantity<Temperature> create(double d, Unit<Temperature> unit) {
            assert (unit == this.getSystemUnit()) : unit;
            return new TemperatureMeasurement(this, d);
        }
    }
}

