/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs.strawman;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class StrawManTikaAppDriver
implements Callable<Integer> {
    private static AtomicInteger threadCount = new AtomicInteger(0);
    private final int totalThreads;
    private final int threadNum;
    private Path inputRoot = null;
    private Path outputRoot = null;
    private String[] args = null;
    private Logger logger = LoggerFactory.getLogger(StrawManTikaAppDriver.class);

    public StrawManTikaAppDriver(Path inputRoot, Path outputRoot, int totalThreads, String[] args) {
        this.inputRoot = inputRoot;
        this.outputRoot = outputRoot;
        this.args = args;
        this.threadNum = threadCount.getAndIncrement();
        this.totalThreads = totalThreads;
    }

    @Override
    public Integer call() throws Exception {
        long start = new Date().getTime();
        TikaVisitor v = new TikaVisitor();
        Files.walkFileTree(this.inputRoot, v);
        int processed = v.getProcessed();
        double elapsedSecs = ((double)new Date().getTime() - (double)start) / 1000.0;
        this.logger.info("Finished processing " + processed + " files in " + elapsedSecs + " seconds.");
        return processed;
    }

    public static String usage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Example usage:\n");
        sb.append("java -cp <CP> org.apache.batch.fs.strawman.StrawManTikaAppDriver ");
        sb.append("<inputDir> <outputDir> <numThreads> ");
        sb.append("java -jar tika-app-X.Xjar <...commandline arguments for tika-app>\n\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        long start = new Date().getTime();
        if (args.length < 6) {
            System.err.println(StrawManTikaAppDriver.usage());
        }
        Path inputDir = Paths.get(args[0], new String[0]);
        Path outputDir = Paths.get(args[1], new String[0]);
        int totalThreads = Integer.parseInt(args[2]);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(Arrays.asList(args).subList(3, args.length));
        totalThreads = totalThreads < 1 ? 1 : totalThreads;
        ExecutorService ex = Executors.newFixedThreadPool(totalThreads);
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(ex);
        for (int i = 0; i < totalThreads; ++i) {
            StrawManTikaAppDriver driver = new StrawManTikaAppDriver(inputDir, outputDir, totalThreads, commandLine.toArray(new String[commandLine.size()]));
            completionService.submit(driver);
        }
        int totalFilesProcessed = 0;
        for (int i = 0; i < totalThreads; ++i) {
            try {
                Future future = completionService.take();
                if (future == null) continue;
                totalFilesProcessed += ((Integer)future.get()).intValue();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        double elapsedSeconds = (double)(new Date().getTime() - start) / 1000.0;
        System.out.println("Processed " + totalFilesProcessed + " in " + elapsedSeconds + " seconds");
    }

    private class RedirectGobbler
    implements Runnable {
        private OutputStream redirectOs = null;
        private InputStream redirectIs = null;

        private RedirectGobbler(InputStream is, OutputStream os) {
            this.redirectIs = is;
            this.redirectOs = os;
        }

        private void close() {
            if (this.redirectOs != null) {
                try {
                    this.redirectOs.flush();
                }
                catch (IOException e) {
                    StrawManTikaAppDriver.this.logger.error("can't flush");
                }
                try {
                    this.redirectIs.close();
                }
                catch (IOException e) {
                    StrawManTikaAppDriver.this.logger.error("can't close input in redirect gobbler");
                }
                try {
                    this.redirectOs.close();
                }
                catch (IOException e) {
                    StrawManTikaAppDriver.this.logger.error("can't close output in redirect gobbler");
                }
            }
        }

        @Override
        public void run() {
            try {
                IOUtils.copy((InputStream)this.redirectIs, (OutputStream)this.redirectOs);
            }
            catch (IOException e) {
                StrawManTikaAppDriver.this.logger.error("IOException while gobbling");
            }
        }
    }

    private class TikaVisitor
    extends SimpleFileVisitor<Path> {
        private int processed = 0;

        private TikaVisitor() {
        }

        int getProcessed() {
            return this.processed;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            int hashCode;
            if (StrawManTikaAppDriver.this.totalThreads > 1 && Math.abs((hashCode = file.toAbsolutePath().toString().hashCode()) % StrawManTikaAppDriver.this.totalThreads) != StrawManTikaAppDriver.this.threadNum) {
                return FileVisitResult.CONTINUE;
            }
            assert (file.startsWith(StrawManTikaAppDriver.this.inputRoot));
            Path relPath = StrawManTikaAppDriver.this.inputRoot.relativize(file);
            Path outputFile = Paths.get(StrawManTikaAppDriver.this.outputRoot.toAbsolutePath().toString(), relPath.toString() + ".txt");
            try {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                StrawManTikaAppDriver.this.logger.error(MarkerFactory.getMarker((String)"FATAL"), "parent directory for " + outputFile + " was not made!");
                throw new RuntimeException("couldn't make parent file for " + outputFile);
            }
            ArrayList<String> commandLine = new ArrayList<String>();
            for (String arg : StrawManTikaAppDriver.this.args) {
                commandLine.add(arg);
            }
            commandLine.add("-t");
            commandLine.add("\"" + outputFile.toAbsolutePath() + "\"");
            ProcessBuilder builder = new ProcessBuilder(commandLine.toArray(new String[commandLine.size()]));
            StrawManTikaAppDriver.this.logger.info("about to process: " + file.toAbsolutePath());
            Process proc = null;
            RedirectGobbler gobbler = null;
            Thread gobblerThread = null;
            try {
                OutputStream os = Files.newOutputStream(outputFile, new OpenOption[0]);
                proc = builder.start();
                gobbler = new RedirectGobbler(proc.getInputStream(), os);
                gobblerThread = new Thread(gobbler);
                gobblerThread.start();
            }
            catch (IOException e) {
                StrawManTikaAppDriver.this.logger.error(e.getMessage());
                return FileVisitResult.CONTINUE;
            }
            boolean finished = false;
            long totalTime = 180000L;
            long pulse = 100L;
            int i = 0;
            while ((long)i < totalTime) {
                try {
                    Thread.currentThread();
                    Thread.sleep(pulse);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    int exit = proc.exitValue();
                    finished = true;
                    break;
                }
                catch (IllegalThreadStateException e) {
                    i = (int)((long)i + pulse);
                }
            }
            if (!finished) {
                StrawManTikaAppDriver.this.logger.warn("Had to kill process working on: " + file.toAbsolutePath());
                proc.destroy();
            }
            gobbler.close();
            gobblerThread.interrupt();
            ++this.processed;
            return FileVisitResult.CONTINUE;
        }
    }
}

