/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.measure.quantity.Angle;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.PrimeMeridian;

public final class ReferencingUtilities
extends Static {
    public static final Logger LOGGER = Logging.getLogger("org.apache.sis.referencing");

    private ReferencingUtilities() {
    }

    public static boolean isGreenwichLongitudeEquals(PrimeMeridian primeMeridian, PrimeMeridian primeMeridian2) {
        if (primeMeridian == null || primeMeridian2 == null) {
            return false;
        }
        return primeMeridian == primeMeridian2 || Numerics.epsilonEqual(primeMeridian.getGreenwichLongitude(), ReferencingUtilities.getGreenwichLongitude(primeMeridian2, primeMeridian.getAngularUnit()));
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian instanceof DefaultPrimeMeridian) {
            return ((DefaultPrimeMeridian)primeMeridian).getGreenwichLongitude(unit);
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static Unit<?> getUnit(CoordinateSystem coordinateSystem) {
        Unit<?> unit = null;
        if (coordinateSystem != null) {
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                Unit<?> unit2;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
                if (coordinateSystemAxis == null || (unit2 = coordinateSystemAxis.getUnit()) == null) continue;
                if (unit == null) {
                    unit = unit2;
                    continue;
                }
                if (unit.equals(unit2)) continue;
                return null;
            }
        }
        return unit;
    }

    public static boolean getSingleComponents(Iterable<? extends CoordinateReferenceSystem> iterable, Collection<? super SingleCRS> collection) throws ClassCastException {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : iterable) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                ReferencingUtilities.getSingleComponents(((CompoundCRS)coordinateReferenceSystem).getComponents(), collection);
                bl = false;
                continue;
            }
            collection.add((SingleCRS)coordinateReferenceSystem);
        }
        return bl;
    }

    public static GeographicCRS toNormalizedGeographicCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
        }
        if (coordinateReferenceSystem instanceof GeodeticCRS) {
            if (coordinateReferenceSystem instanceof DefaultGeographicCRS && coordinateReferenceSystem.getCoordinateSystem().getDimension() == 2) {
                return ((DefaultGeographicCRS)coordinateReferenceSystem).forConvention(AxesConvention.NORMALIZED);
            }
            EllipsoidalCS ellipsoidalCS = CommonCRS.defaultGeographic().getCoordinateSystem();
            if (coordinateReferenceSystem instanceof GeographicCRS && Utilities.equalsIgnoreMetadata(ellipsoidalCS, coordinateReferenceSystem.getCoordinateSystem())) {
                return (GeographicCRS)coordinateReferenceSystem;
            }
            return new DefaultGeographicCRS(Collections.singletonMap("name", Vocabulary.format((short)65)), ((GeodeticCRS)coordinateReferenceSystem).getDatum(), ellipsoidalCS);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem2);
                if (geographicCRS == null) continue;
                return geographicCRS;
            }
        }
        return null;
    }

    public static String toWKTType(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 != clazz) {
            Object object;
            int n;
            UML uML = clazz2.getAnnotation(UML.class);
            if (uML != null && uML.specification() == Specification.ISO_19111 && (n = ((String)(object = uML.identifier())).length() - 5) >= 1 && ((String)object).startsWith("CS_") && ((String)object).endsWith("CS")) {
                StringBuilder stringBuilder = new StringBuilder(n).append((CharSequence)object, 3, 3 + n);
                if (!((String)object).regionMatches(3, "Cartesian", 0, 9)) {
                    stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
                }
                if (((String)(object = stringBuilder.toString())).equals("time")) {
                    object = "temporal";
                }
                return object;
            }
            for (Class<?> clazz3 : clazz2.getInterfaces()) {
                String string;
                if (!clazz.isAssignableFrom(clazz3) || (string = ReferencingUtilities.toWKTType(clazz, clazz3)) == null) continue;
                return string;
            }
        }
        return null;
    }

    public static boolean canSetProperty(Class<?> clazz, String string, String string2, boolean bl) throws IllegalStateException {
        if (!bl) {
            return true;
        }
        Context context = Context.current();
        if (context != null) {
            Context.warningOccured(context, LOGGER, clazz, string, Errors.class, (short)19, string2);
            return false;
        }
        throw new IllegalStateException(Errors.format((short)19, string2));
    }
}

