/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

public final class WKTUtilities
extends Static {
    private WKTUtilities() {
    }

    public static FormattableObject toFormattable(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof FormattableObject) {
            return (FormattableObject)((Object)coordinateReferenceSystem);
        }
        return AbstractCRS.castOrCopy(coordinateReferenceSystem);
    }

    public static FormattableObject toFormattable(CoordinateSystem coordinateSystem) {
        if (coordinateSystem instanceof FormattableObject) {
            return (FormattableObject)((Object)coordinateSystem);
        }
        return AbstractCS.castOrCopy(coordinateSystem);
    }

    public static FormattableObject toFormattable(CoordinateSystemAxis coordinateSystemAxis) {
        if (coordinateSystemAxis instanceof FormattableObject) {
            return (FormattableObject)((Object)coordinateSystemAxis);
        }
        return DefaultCoordinateSystemAxis.castOrCopy(coordinateSystemAxis);
    }

    public static FormattableObject toFormattable(Datum datum) {
        if (datum instanceof FormattableObject) {
            return (FormattableObject)((Object)datum);
        }
        return AbstractDatum.castOrCopy(datum);
    }

    public static FormattableObject toFormattable(GeodeticDatum geodeticDatum) {
        if (geodeticDatum instanceof FormattableObject) {
            return (FormattableObject)((Object)geodeticDatum);
        }
        return DefaultGeodeticDatum.castOrCopy(geodeticDatum);
    }

    public static FormattableObject toFormattable(Ellipsoid ellipsoid) {
        if (ellipsoid instanceof FormattableObject) {
            return (FormattableObject)((Object)ellipsoid);
        }
        return DefaultEllipsoid.castOrCopy(ellipsoid);
    }

    public static FormattableObject toFormattable(PrimeMeridian primeMeridian) {
        if (primeMeridian instanceof FormattableObject) {
            return (FormattableObject)((Object)primeMeridian);
        }
        return DefaultPrimeMeridian.castOrCopy(primeMeridian);
    }

    public static void appendName(IdentifiedObject identifiedObject, Formatter formatter, ElementKind elementKind) {
        String string = IdentifiedObjects.getName(identifiedObject, formatter.getNameAuthority());
        if (string == null && (string = IdentifiedObjects.getName(identifiedObject, null)) == null) {
            string = Vocabulary.getResources(formatter.getLocale()).getString((short)65);
        }
        formatter.append(string, elementKind != null ? elementKind : ElementKind.NAME);
    }

    public static void append(GeneralParameterValue defaultParameterValue, Formatter formatter) {
        if (defaultParameterValue instanceof ParameterValueGroup) {
            boolean bl = true;
            for (GeneralParameterValue generalParameterValue : ((ParameterValueGroup)((Object)defaultParameterValue)).values()) {
                if (bl) {
                    formatter.newLine();
                    bl = false;
                }
                WKTUtilities.append(generalParameterValue, formatter);
            }
        }
        if (defaultParameterValue instanceof ParameterValue) {
            if (!(defaultParameterValue instanceof FormattableObject)) {
                defaultParameterValue = new DefaultParameterValue(defaultParameterValue);
            }
            formatter.append(defaultParameterValue);
            formatter.newLine();
        }
    }
}

