/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -1978932430298071693L;
    private final Class<T> valueClass;
    private final Set<T> validValues;
    private final Range<?> valueDomain;
    private final T defaultValue;

    public DefaultParameterDescriptor(Map<String, ?> map, int n, int n2, Class<T> clazz, Range<?> range, T[] TArray, T t) {
        super(map, n, n2);
        Class<Object> clazz2;
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        ArgumentChecks.ensureCanCast("defaultValue", clazz, t);
        if (range != null) {
            clazz2 = clazz.getComponentType();
            clazz2 = clazz2 != null ? Numbers.primitiveToWrapper(clazz2) : clazz;
            T[] TArray2 = range.getElementType();
            if (TArray2 != clazz2) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)28, "valueDomain", "Range<" + Classes.getShortName(TArray2) + '>'));
            }
            if (range.isEmpty()) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)41, range.getMinValue(), range.getMaxValue()));
            }
        }
        this.valueClass = clazz;
        this.valueDomain = range;
        this.defaultValue = Numerics.cached(t);
        if (TArray != null) {
            clazz2 = CollectionsExt.createSetForType(clazz, TArray.length);
            for (T t2 : TArray) {
                if (t2 == null) continue;
                Verifier verifier = Verifier.ensureValidValue(clazz, null, range, t2 = Numerics.cached(t2));
                if (verifier != null) {
                    throw new IllegalArgumentException(verifier.message(map, super.getName().getCode(), t2));
                }
                clazz2.add(t2);
            }
            this.validValues = CollectionsExt.unmodifiableOrCopy(clazz2);
        } else {
            this.validValues = null;
        }
        if (t != null && (clazz2 = Verifier.ensureValidValue(clazz, this.validValues, range, t)) != null) {
            throw new IllegalArgumentException(((Verifier)((Object)clazz2)).message(map, super.getName().getCode(), t));
        }
    }

    @Deprecated
    public DefaultParameterDescriptor(Map<String, ?> map, Class<T> clazz, Range<?> range, T[] TArray, T t, boolean bl) {
        this(map, bl ? 1 : 0, 1, clazz, range, TArray, t);
    }

    protected DefaultParameterDescriptor(ParameterDescriptor<T> parameterDescriptor) {
        super(parameterDescriptor);
        this.valueClass = parameterDescriptor.getValueClass();
        this.validValues = parameterDescriptor.getValidValues();
        this.defaultValue = parameterDescriptor.getDefaultValue();
        this.valueDomain = Parameters.getValueDomain(parameterDescriptor);
    }

    public static <T> DefaultParameterDescriptor<T> castOrCopy(ParameterDescriptor<T> parameterDescriptor) {
        return parameterDescriptor == null || parameterDescriptor instanceof DefaultParameterDescriptor ? (DefaultParameterDescriptor<T>)parameterDescriptor : new DefaultParameterDescriptor<T>(parameterDescriptor);
    }

    public Class<? extends ParameterDescriptor<T>> getInterface() {
        return ParameterDescriptor.class;
    }

    @Override
    public final Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Set<T> getValidValues() {
        return this.validValues;
    }

    public final Range<?> getValueDomain() {
        return this.valueDomain;
    }

    @Override
    public Comparable<T> getMinimumValue() {
        return this.valueDomain != null && this.valueDomain.getElementType() == this.valueClass ? (Comparable<T>)this.valueDomain.getMinValue() : null;
    }

    @Override
    public Comparable<T> getMaximumValue() {
        return this.valueDomain != null && this.valueDomain.getElementType() == this.valueClass ? (Comparable<T>)this.valueDomain.getMaxValue() : null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Unit<?> getUnit() {
        return this.valueDomain instanceof MeasurementRange ? ((MeasurementRange)this.valueDomain).unit() : null;
    }

    @Override
    public ParameterValue<T> createValue() {
        return new DefaultParameterValue(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                default: {
                    ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
                    return this.getValueClass() == parameterDescriptor.getValueClass() && Objects.deepEquals(this.getDefaultValue(), parameterDescriptor.getDefaultValue()) && Objects.equals(this.getUnit(), parameterDescriptor.getUnit()) && (this.isHeuristicMatchForName(parameterDescriptor.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName(parameterDescriptor, this.getName().getCode()));
                }
                case BY_CONTRACT: {
                    ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
                    return this.getMinimumOccurs() == parameterDescriptor.getMinimumOccurs() && this.getMaximumOccurs() == parameterDescriptor.getMaximumOccurs() && this.getValueClass() == parameterDescriptor.getValueClass() && Objects.equals(this.getValidValues(), parameterDescriptor.getValidValues()) && Objects.equals(this.getMinimumValue(), parameterDescriptor.getMinimumValue()) && Objects.equals(this.getMaximumValue(), parameterDescriptor.getMaximumValue()) && Objects.deepEquals(this.getDefaultValue(), parameterDescriptor.getDefaultValue()) && Objects.equals(this.getUnit(), parameterDescriptor.getUnit());
                }
                case STRICT: 
            }
            DefaultParameterDescriptor defaultParameterDescriptor = (DefaultParameterDescriptor)object;
            return this.valueClass == defaultParameterDescriptor.valueClass && Objects.equals(this.validValues, defaultParameterDescriptor.validValues) && Objects.equals(this.valueDomain, defaultParameterDescriptor.valueDomain) && Objects.deepEquals(this.defaultValue, defaultParameterDescriptor.defaultValue);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return (long)Arrays.deepHashCode(new Object[]{this.valueClass, this.valueDomain, this.defaultValue}) + super.computeHashCode();
    }
}

