/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import javax.measure.unit.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.Builder;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class ParameterBuilder
extends Builder<ParameterBuilder> {
    private boolean required;

    public ParameterBuilder setRequired(boolean bl) {
        this.required = bl;
        return this;
    }

    public ParameterDescriptor<Double> create(double d, Unit<?> unit) {
        MeasurementRange<Double> measurementRange = unit != null ? MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, unit) : null;
        return this.create(Double.class, measurementRange, null, d);
    }

    public <T> ParameterDescriptor<T> create(Class<T> clazz, T t) {
        return this.create(clazz, null, null, t);
    }

    public ParameterDescriptor<Double> createStrictlyPositive(double d, Unit<?> unit) {
        NumberRange numberRange = unit != null ? MeasurementRange.create(0.0, false, Double.POSITIVE_INFINITY, false, unit) : NumberRange.create(0.0, false, Double.POSITIVE_INFINITY, false);
        return this.create(Double.class, numberRange, null, d);
    }

    public ParameterDescriptor<Double> createBounded(double d, double d2, double d3, Unit<?> unit) {
        NumberRange numberRange = unit != null ? MeasurementRange.create(d, true, d2, true, unit) : (d != Double.NEGATIVE_INFINITY || d2 != Double.POSITIVE_INFINITY ? NumberRange.create(d, true, d2, true) : null);
        return this.create(Double.class, numberRange, null, d3);
    }

    public ParameterDescriptor<Integer> createBounded(int n, int n2, int n3) {
        return this.create(Integer.class, NumberRange.create(n, true, n2, true), null, n3);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Class<T> clazz, T t, T t2, T t3) {
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        Range range = t == null && t2 == null ? null : (Number.class.isAssignableFrom(clazz) ? new NumberRange<Number>(clazz, (Number)((Object)t), true, (Number)((Object)t2), true) : new Range(clazz, t, true, t2, true));
        return this.create(clazz, range, null, t3);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Range<T> range, T t) {
        ArgumentChecks.ensureNonNull("valueDomain", range);
        return this.create(range.getElementType(), range, null, t);
    }

    public <T> ParameterDescriptor<T> createEnumerated(Class<T> clazz, T[] TArray, T t) {
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        return this.create(clazz, null, TArray, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ParameterDescriptor<T> create(Class<T> clazz, Range<?> range, T[] TArray, T t) {
        DefaultParameterDescriptor<T> defaultParameterDescriptor;
        this.onCreate(false);
        try {
            defaultParameterDescriptor = new DefaultParameterDescriptor<T>(this.properties, this.required ? 1 : 0, 1, clazz, range, TArray, t);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptor;
    }

    public ParameterDescriptorGroup createGroup(GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        return this.createGroup(this.required ? 1 : 0, 1, generalParameterDescriptorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptorGroup createGroup(int n, int n2, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        DefaultParameterDescriptorGroup defaultParameterDescriptorGroup;
        this.onCreate(false);
        try {
            defaultParameterDescriptorGroup = new DefaultParameterDescriptorGroup(this.properties, n, n2, generalParameterDescriptorArray);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptorGroup;
    }
}

