/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public abstract class Builder<B extends Builder<B>> {
    protected final Map<String, Object> properties;
    private final List<GenericName> aliases;
    private final List<ReferenceIdentifier> identifiers;
    private NameSpace namespace;

    protected Builder() {
        assert (Builder.verifyParameterizedType(this.getClass()));
        this.properties = new HashMap<String, Object>(8);
        this.aliases = new ArrayList<GenericName>(4);
        this.identifiers = new ArrayList<ReferenceIdentifier>(4);
    }

    private static boolean verifyParameterizedType(Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            ParameterizedType parameterizedType;
            Type type = clazz2.getGenericSuperclass();
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Builder.class) continue;
            type = parameterizedType.getActualTypeArguments()[0];
            if (type == clazz) {
                return true;
            }
            throw new AssertionError(type);
        }
        return false;
    }

    private B self() {
        return (B)this;
    }

    private boolean setProperty(String string, Object object) throws IllegalStateException {
        if (Objects.equals(this.properties.get(string), object)) {
            return false;
        }
        if (this.properties.get("name") != null) {
            throw new IllegalStateException(Errors.format((short)131, string));
        }
        this.properties.put(string, object);
        return true;
    }

    private NameSpace namespace() {
        String string;
        if (this.namespace == null && (string = (String)this.properties.get("codespace")) != null) {
            this.namespace = DefaultFactories.NAMES.createNameSpace(DefaultFactories.NAMES.createLocalName(null, string), null);
        }
        return this.namespace;
    }

    public B setCodeSpace(Citation citation, String string) {
        if (!this.setProperty("codespace", string)) {
            this.namespace = null;
        }
        this.setProperty("authority", citation);
        return this.self();
    }

    public B setVersion(String string) {
        this.setProperty("version", string);
        return this.self();
    }

    public B addName(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("name", charSequence);
        Object object = this.properties.put("name", charSequence.toString());
        if (object != null) {
            this.properties.put("name", object);
            this.aliases.add(charSequence instanceof GenericName ? (GenericName)((Object)charSequence) : DefaultFactories.NAMES.createLocalName(this.namespace(), charSequence));
        }
        return this.self();
    }

    public B addName(Citation citation, CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("name", charSequence);
        NamedIdentifier namedIdentifier = charSequence instanceof InternationalString ? new NamedIdentifier(citation, (InternationalString)charSequence) : new NamedIdentifier(citation, charSequence.toString());
        Object object = this.properties.put("name", namedIdentifier);
        if (object != null) {
            this.properties.put("name", object);
            this.aliases.add(namedIdentifier);
        }
        return this.self();
    }

    public B addName(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("name", referenceIdentifier);
        Object object = this.properties.put("name", referenceIdentifier);
        if (object != null) {
            this.properties.put("name", object);
            this.aliases.add(referenceIdentifier instanceof GenericName ? (GenericName)((Object)referenceIdentifier) : new NamedIdentifier(referenceIdentifier));
        }
        return this.self();
    }

    public B addName(GenericName genericName) {
        ArgumentChecks.ensureNonNull("name", genericName);
        if (this.properties.get("name") == null) {
            this.properties.put("name", new NamedIdentifier(genericName));
        } else {
            this.aliases.add(genericName);
        }
        return this.self();
    }

    public B addIdentifier(String string) {
        ArgumentChecks.ensureNonNull("identifier", string);
        this.identifiers.add(new ImmutableIdentifier((Citation)this.properties.get("authority"), (String)this.properties.get("codespace"), string));
        return this.self();
    }

    public B addIdentifier(Citation citation, String string) {
        ArgumentChecks.ensureNonNull("identifier", string);
        this.identifiers.add(new ImmutableIdentifier(citation, Citations.getIdentifier(citation), string));
        return this.self();
    }

    public B addIdentifier(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("identifier", referenceIdentifier);
        this.identifiers.add(referenceIdentifier);
        return this.self();
    }

    public B setDescription(CharSequence charSequence) {
        this.properties.put("description", charSequence);
        return this.self();
    }

    public B setRemarks(CharSequence charSequence) {
        this.properties.put("remarks", charSequence);
        return this.self();
    }

    protected void onCreate(boolean bl) {
        this.properties.put("alias", bl ? null : this.aliases.toArray(new GenericName[this.aliases.size()]));
        this.properties.put("identifiers", bl ? null : this.identifiers.toArray(new ReferenceIdentifier[this.identifiers.size()]));
        if (bl) {
            this.properties.put("name", null);
            this.properties.remove("remarks");
            this.aliases.clear();
            this.identifiers.clear();
        }
    }
}

