/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.OperationMethods;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultImageDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.datum.SubTypes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDatumType", propOrder={"domainOfValidity", "scope", "anchorDefinition", "realizationEpoch"})
@XmlRootElement(name="AbstractDatum")
@XmlSeeAlso(value={DefaultGeodeticDatum.class, DefaultVerticalDatum.class, DefaultTemporalDatum.class, DefaultEngineeringDatum.class, DefaultImageDatum.class})
public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String ESRI_PREFIX = "D_";
    @XmlElement
    private final InternationalString anchorDefinition;
    private long realizationEpoch;
    @XmlElement
    private final Extent domainOfValidity;
    @XmlElement
    private final InternationalString scope;

    AbstractDatum() {
        super(NilReferencingObject.INSTANCE);
        this.anchorDefinition = null;
        this.realizationEpoch = Long.MIN_VALUE;
        this.domainOfValidity = null;
        this.scope = null;
    }

    public AbstractDatum(Map<String, ?> map) {
        super(map);
        this.realizationEpoch = MetadataUtilities.toMilliseconds(Containers.property(map, "realizationEpoch", Date.class));
        this.domainOfValidity = Containers.property(map, "domainOfValidity", Extent.class);
        this.anchorDefinition = Types.toInternationalString(map, "anchorPoint");
        this.scope = Types.toInternationalString(map, "scope");
    }

    protected AbstractDatum(Datum datum) {
        super(datum);
        this.realizationEpoch = MetadataUtilities.toMilliseconds(datum.getRealizationEpoch());
        this.domainOfValidity = datum.getDomainOfValidity();
        this.scope = datum.getScope();
        this.anchorDefinition = datum.getAnchorPoint();
    }

    public static AbstractDatum castOrCopy(Datum datum) {
        return SubTypes.castOrCopy(datum);
    }

    public Class<? extends Datum> getInterface() {
        return Datum.class;
    }

    @Override
    public InternationalString getAnchorPoint() {
        return this.anchorDefinition;
    }

    @Override
    @XmlElement(name="realizationEpoch")
    public Date getRealizationEpoch() {
        return MetadataUtilities.toDate(this.realizationEpoch);
    }

    private void setRealizationEpoch(Date date) {
        if (date != null && ReferencingUtilities.canSetProperty(AbstractDatum.class, "setRealizationEpoch", "realizationEpoch", this.realizationEpoch != Long.MIN_VALUE)) {
            this.realizationEpoch = date.getTime();
        }
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean isHeuristicMatchForName(String string) {
        if (string.startsWith(ESRI_PREFIX) ? super.isHeuristicMatchForName(string.substring(ESRI_PREFIX.length())) : this.getName().getCode().startsWith(ESRI_PREFIX) && super.isHeuristicMatchForName(ESRI_PREFIX.concat(string))) {
            return true;
        }
        return super.isHeuristicMatchForName(string);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractDatum abstractDatum = (AbstractDatum)object;
                return this.realizationEpoch == abstractDatum.realizationEpoch && Objects.equals(this.domainOfValidity, abstractDatum.domainOfValidity) && Objects.equals(this.anchorDefinition, abstractDatum.anchorDefinition) && Objects.equals(this.scope, abstractDatum.scope);
            }
            case BY_CONTRACT: {
                Datum datum = (Datum)object;
                return Utilities.deepEquals(this.getRealizationEpoch(), datum.getRealizationEpoch(), comparisonMode) && Utilities.deepEquals(this.getDomainOfValidity(), datum.getDomainOfValidity(), comparisonMode) && Utilities.deepEquals(this.getAnchorPoint(), datum.getAnchorPoint(), comparisonMode) && Utilities.deepEquals(this.getScope(), datum.getScope(), comparisonMode);
            }
        }
        Datum datum = (Datum)object;
        Boolean bl = OperationMethods.hasCommonIdentifier(this.getIdentifiers(), datum.getIdentifiers());
        if (bl != null) {
            return bl;
        }
        return this.isHeuristicMatchForName(datum.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName(datum, this.getName().getCode());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.anchorDefinition, this.realizationEpoch, this.domainOfValidity, this.scope);
    }
}

