/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.Measure;
import org.apache.sis.internal.jaxb.referencing.SecondDefiningParameter;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.Sphere;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.datum.Ellipsoid;

@XmlType(name="EllipsoidType", propOrder={"semiMajorAxisMeasure", "secondDefiningParameter"})
@XmlRootElement(name="Ellipsoid")
public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    private static final int MAX_ITERATIONS = 100;
    private static final double EPS = 5.0E-14;
    private static final double COMPARISON_THRESHOLD = 1.0E-10;
    private double semiMajorAxis;
    private double semiMinorAxis;
    private double inverseFlattening;
    private boolean ivfDefinitive;
    private Unit<Length> unit;

    private DefaultEllipsoid() {
        super(NilReferencingObject.INSTANCE);
    }

    protected DefaultEllipsoid(Map<String, ?> map, double d, double d2, double d3, boolean bl, Unit<Length> unit) {
        super(map);
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureStrictlyPositive("semiMajorAxis", d);
        ArgumentChecks.ensureStrictlyPositive("semiMinorAxis", d2);
        ArgumentChecks.ensureStrictlyPositive("inverseFlattening", d3);
        this.unit = unit;
        this.semiMajorAxis = d;
        this.semiMinorAxis = d2;
        this.inverseFlattening = d3;
        this.ivfDefinitive = bl;
    }

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super(ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (d == d2) {
            return new Sphere(map, d, false, unit);
        }
        return new DefaultEllipsoid(map, d, d2, d / (d - d2), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (Double.isInfinite(d2)) {
            return new Sphere(map, d, true, unit);
        }
        return new DefaultEllipsoid(map, d, d * (1.0 - 1.0 / d2), d2, true, unit);
    }

    public static DefaultEllipsoid castOrCopy(Ellipsoid ellipsoid) {
        if (ellipsoid == null || ellipsoid instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)ellipsoid;
        }
        Map<String, ?> map = IdentifiedObjects.getProperties(ellipsoid, new String[0]);
        double d = ellipsoid.getSemiMajorAxis();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        return ellipsoid.isIvfDefinitive() ? DefaultEllipsoid.createFlattenedSphere(map, d, ellipsoid.getInverseFlattening(), unit) : DefaultEllipsoid.createEllipsoid(map, d, ellipsoid.getSemiMinorAxis(), unit);
    }

    private void afterUnmarshal() {
        if (this.ivfDefinitive) {
            if (this.semiMinorAxis == 0.0) {
                this.semiMinorAxis = this.semiMajorAxis * (1.0 - 1.0 / this.inverseFlattening);
            }
        } else if (this.inverseFlattening == 0.0) {
            this.inverseFlattening = this.semiMajorAxis / (this.semiMajorAxis - this.semiMinorAxis);
        }
        if (this.unit == null) {
            Measure.missingUOM(DefaultEllipsoid.class, "semiMajorAxis");
        }
    }

    public Class<? extends Ellipsoid> getInterface() {
        return Ellipsoid.class;
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @XmlElement(name="semiMajorAxis", required=true)
    final Measure getSemiMajorAxisMeasure() {
        return new Measure(this.semiMajorAxis, this.unit);
    }

    private void setSemiMajorAxisMeasure(Measure measure) throws ConversionException {
        if (this.semiMajorAxis != 0.0) {
            DefaultEllipsoid.warnDuplicated("semiMajorAxis");
        } else {
            Unit<Length> unit = this.unit;
            this.semiMajorAxis = measure.value;
            ArgumentChecks.ensureStrictlyPositive("semiMajorAxis", this.semiMajorAxis);
            this.unit = measure.getUnit(Length.class);
            this.harmonizeAxisUnits(unit);
            if ((this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis) != 0.0) {
                this.afterUnmarshal();
            }
        }
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getAuthalicRadius() {
        return Formulas.getAuthalicRadius(this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public double getEccentricity() {
        double d = 1.0 - this.getSemiMinorAxis() / this.getSemiMajorAxis();
        return Math.sqrt(2.0 * d - d * d);
    }

    @Override
    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    @Override
    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    @XmlElement(name="secondDefiningParameter")
    final SecondDefiningParameter getSecondDefiningParameter() {
        return new SecondDefiningParameter(this, true);
    }

    private void setSecondDefiningParameter(SecondDefiningParameter secondDefiningParameter) throws ConversionException {
        while (secondDefiningParameter.secondDefiningParameter != null) {
            secondDefiningParameter = secondDefiningParameter.secondDefiningParameter;
        }
        Measure measure = secondDefiningParameter.measure;
        if (measure != null) {
            boolean bl = secondDefiningParameter.isIvfDefinitive();
            if ((bl ? this.inverseFlattening : this.semiMinorAxis) != 0.0) {
                DefaultEllipsoid.warnDuplicated("secondDefiningParameter");
            } else {
                this.ivfDefinitive = bl;
                double d = measure.value;
                if (bl) {
                    if (d == 0.0) {
                        d = Double.POSITIVE_INFINITY;
                    }
                    this.inverseFlattening = d;
                    ArgumentChecks.ensureStrictlyPositive("inverseFlattening", this.inverseFlattening);
                } else if (this.semiMinorAxis == 0.0) {
                    this.semiMinorAxis = d;
                    ArgumentChecks.ensureStrictlyPositive("semiMinorAxis", this.semiMinorAxis);
                    this.harmonizeAxisUnits(measure.getUnit(Length.class));
                }
                if (this.semiMajorAxis != 0.0) {
                    this.afterUnmarshal();
                }
            }
        }
    }

    private void harmonizeAxisUnits(Unit<Length> unit) throws ConversionException {
        if (this.unit == null) {
            this.unit = unit;
        } else if (unit != null && unit != this.unit) {
            this.semiMinorAxis = unit.getConverterToAny(this.unit).convert(this.semiMinorAxis);
        }
    }

    private static void warnDuplicated(String string) {
        Context.warningOccured(Context.current(), ReferencingUtilities.LOGGER, DefaultEllipsoid.class, "unmarshal", Errors.class, (short)16, string);
    }

    @Override
    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double orthodromicDistance(double d, double d2, double d3, double d4) {
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        d4 = Math.toRadians(d4);
        double d5 = 1.0 / this.getInverseFlattening();
        double d6 = 1.0 - d5;
        double d7 = d6 * Math.tan(d2);
        double d8 = d6 * Math.tan(d4);
        double d9 = 1.0 / Math.sqrt(d7 * d7 + 1.0);
        double d10 = 1.0 / Math.sqrt(d8 * d8 + 1.0);
        double d11 = d9 * d7;
        double d12 = d9 * d10;
        double d13 = d12 * d8;
        double d14 = d13 * d7;
        double d15 = d3 - d;
        for (int i = 0; i < 100; ++i) {
            double d16 = Math.sin(d15);
            double d17 = Math.cos(d15);
            d7 = d10 * d16;
            d8 = d13 - d11 * d10 * d17;
            double d18 = Math.hypot(d7, d8);
            double d19 = d12 * d17 + d14;
            double d20 = Math.atan2(d18, d19);
            double d21 = d12 * (d16 / d18);
            double d22 = 1.0 - d21 * d21;
            double d23 = 2.0 * d14;
            if (d22 > 0.0) {
                d23 = -d23 / d22 + d19;
            }
            double d24 = d23 * d23 * 2.0 - 1.0;
            double d25 = ((-3.0 * d22 + 4.0) * d5 + 4.0) * d22 * d5 / 16.0;
            double d26 = d15;
            d15 = ((d24 * d19 * d25 + d23) * d18 * d25 + d20) * d21;
            if (!(Math.abs(d26 - (d15 = (1.0 - d25) * d15 * d5 + d3 - d)) <= 5.0E-14)) continue;
            d15 = Math.sqrt((1.0 / (d6 * d6) - 1.0) * d22 + 1.0) + 1.0;
            d15 = (d15 - 2.0) / d15;
            d25 = 1.0 - d15;
            d25 = (d15 * d15 / 4.0 + 1.0) / d25;
            d26 = (0.375 * d15 * d15 - 1.0) * d15;
            d15 = d24 * d19;
            d12 = 1.0 - 2.0 * d24;
            d12 = ((((d18 * d18 * 4.0 - 3.0) * d12 * d23 * d26 / 6.0 - d15) * d26 / 4.0 + d23) * d18 * d26 + d20) * d25 * d6 * this.getSemiMajorAxis();
            return d12;
        }
        if (Math.abs(d - d3) <= 1.0E-10 && Math.abs(d2 - d4) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(d2) <= 1.0E-10 && Math.abs(d4) <= 1.0E-10) {
            return Math.abs(d - d3) * this.getSemiMajorAxis();
        }
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            return Double.NaN;
        }
        throw new ArithmeticException(Errors.format((short)69, new DirectPosition2D(Math.toDegrees(d), Math.toDegrees(d2)), new DirectPosition2D(Math.toDegrees(d3), Math.toDegrees(d4))));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)object;
                return this.ivfDefinitive == defaultEllipsoid.ivfDefinitive && Numerics.equals(this.semiMajorAxis, defaultEllipsoid.semiMajorAxis) && Numerics.equals(this.semiMinorAxis, defaultEllipsoid.semiMinorAxis) && Numerics.equals(this.inverseFlattening, defaultEllipsoid.inverseFlattening) && Objects.equals(this.unit, defaultEllipsoid.unit);
            }
            case BY_CONTRACT: {
                if (this.isIvfDefinitive() == ((Ellipsoid)object).isIvfDefinitive()) break;
                return false;
            }
        }
        Ellipsoid ellipsoid = (Ellipsoid)object;
        return Numerics.epsilonEqual(this.getSemiMajorAxis(), ellipsoid.getSemiMajorAxis(), comparisonMode) && Numerics.epsilonEqual(this.getSemiMinorAxis(), ellipsoid.getSemiMinorAxis(), comparisonMode) && Numerics.epsilonEqual(this.getInverseFlattening(), ellipsoid.getInverseFlattening(), comparisonMode) && Objects.equals(this.getAxisUnit(), ellipsoid.getAxisUnit());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.semiMajorAxis) + 31L * Double.doubleToLongBits(this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        double d = this.semiMajorAxis;
        if (bl) {
            d = this.unit.getConverterTo((Unit)SI.METRE).convert(d);
        }
        formatter.append(d);
        formatter.append(Double.isInfinite(this.inverseFlattening) ? 0.0 : this.inverseFlattening);
        if (bl) {
            return "Spheroid";
        }
        if (!convention.isSimplified() || !SI.METRE.equals(this.unit)) {
            formatter.append(this.unit);
        }
        return "Ellipsoid";
    }
}

