/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gco.Measure;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlType(name="PrimeMeridianType")
@XmlRootElement(name="PrimeMeridian")
public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    private double greenwichLongitude;
    private Unit<Angle> angularUnit;

    private DefaultPrimeMeridian() {
        super(NilReferencingObject.INSTANCE);
    }

    public DefaultPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) {
        super(map);
        ArgumentChecks.ensureFinite("greenwichLongitude", d);
        ArgumentChecks.ensureNonNull("angularUnit", unit);
        this.greenwichLongitude = d;
        this.angularUnit = unit;
    }

    protected DefaultPrimeMeridian(PrimeMeridian primeMeridian) {
        super(primeMeridian);
        this.greenwichLongitude = primeMeridian.getGreenwichLongitude();
        this.angularUnit = primeMeridian.getAngularUnit();
    }

    public static DefaultPrimeMeridian castOrCopy(PrimeMeridian primeMeridian) {
        return primeMeridian == null || primeMeridian instanceof DefaultPrimeMeridian ? (DefaultPrimeMeridian)primeMeridian : new DefaultPrimeMeridian(primeMeridian);
    }

    public Class<? extends PrimeMeridian> getInterface() {
        return PrimeMeridian.class;
    }

    @Override
    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> unit) {
        return this.getAngularUnit().getConverterTo(unit).convert(this.getGreenwichLongitude());
    }

    @Override
    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @XmlElement(name="greenwichLongitude", required=true)
    private Measure getGreenwichMeasure() {
        return new Measure(this.greenwichLongitude, this.angularUnit);
    }

    private void setGreenwichMeasure(Measure measure) {
        if (measure != null && ReferencingUtilities.canSetProperty(DefaultPrimeMeridian.class, "setGreenwichMeasure", "greenwichLongitude", this.greenwichLongitude != 0.0 || this.angularUnit != null)) {
            this.greenwichLongitude = measure.value;
            this.angularUnit = measure.getUnit(Angle.class);
            if (this.angularUnit == null) {
                if (this.greenwichLongitude == 0.0) {
                    this.angularUnit = NonSI.DEGREE_ANGLE;
                } else {
                    Measure.missingUOM(DefaultPrimeMeridian.class, "setGreenwichMeasure");
                }
            }
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultPrimeMeridian defaultPrimeMeridian = (DefaultPrimeMeridian)object;
                return Numerics.equals(this.greenwichLongitude, defaultPrimeMeridian.greenwichLongitude) && Objects.equals(this.angularUnit, defaultPrimeMeridian.angularUnit);
            }
            case BY_CONTRACT: {
                PrimeMeridian primeMeridian = (PrimeMeridian)object;
                return Numerics.equals(this.getGreenwichLongitude(), primeMeridian.getGreenwichLongitude()) && Objects.equals(this.getAngularUnit(), primeMeridian.getAngularUnit());
            }
        }
        DefaultPrimeMeridian defaultPrimeMeridian = DefaultPrimeMeridian.castOrCopy((PrimeMeridian)object);
        return Numerics.epsilonEqual(this.getGreenwichLongitude((Unit<Angle>)NonSI.DEGREE_ANGLE), defaultPrimeMeridian.getGreenwichLongitude((Unit<Angle>)NonSI.DEGREE_ANGLE), comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.greenwichLongitude) + (long)Objects.hashCode(this.angularUnit);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        Unit unit = formatter.toContextualUnit(NonSI.DEGREE_ANGLE);
        if (unit == null) {
            unit = NonSI.DEGREE_ANGLE;
        }
        formatter.append(bl ? this.getGreenwichLongitude((Unit<Angle>)unit) : this.greenwichLongitude);
        if (bl) {
            return "PrimeM";
        }
        if (!convention.isSimplified() || !unit.equals(this.angularUnit)) {
            formatter.append(this.angularUnit);
        }
        return "PrimeMeridian";
    }
}

