/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.BitSet;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.data.Word;

public class Verb
extends Word {
    static final long serialVersionUID = 1639186403690898842L;
    private BitSet _verbFrameFlags;
    private transient String _cachedToString = null;

    public Verb(Synset synset, int index, String lemma, BitSet verbFrameFlags) {
        super(synset, index, lemma);
        this._verbFrameFlags = verbFrameFlags;
    }

    public BitSet getVerbFrameFlags() {
        return this._verbFrameFlags;
    }

    public int[] getVerbFrameIndicies() {
        return VerbFrame.getVerbFrameIndicies(this._verbFrameFlags);
    }

    public String[] getVerbFrames() {
        return VerbFrame.getFrames(this.getVerbFrameFlags());
    }

    private String getVerbFramesAsString() {
        String[] frames = this.getVerbFrames();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < frames.length) {
            buf.append(frames[i]);
            if (i != frames.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_008", new Object[]{this.getPOS(), this.getLemma(), this.getSynset(), new Integer(this.getIndex()), this.getVerbFramesAsString()});
        }
        return this._cachedToString;
    }
}

