/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.ValueConverter;

public final class Context
extends MarshalContext {
    public static final int MARSHALLING = 1;
    public static final int SUBSTITUTE_LANGUAGE = 2;
    public static final int SUBSTITUTE_COUNTRY = 4;
    public static final int SUBSTITUTE_FILENAME = 8;
    public static final int SUBSTITUTE_MIMETYPE = 16;
    private static final int CLEAR_SEMAPHORE = 32;
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    public static final Logger LOGGER = Logging.getLogger("org.apache.sis.xml");
    private int bitMasks;
    private Locale locale;
    private TimeZone timezone;
    private Map<String, String> schemas;
    private Version versionGML;
    private ReferenceResolver resolver;
    private ValueConverter converter;
    private WarningListener<?> warningListener;
    private final Context previous;

    public Context(int n, Locale locale, TimeZone timeZone, Map<String, String> map, Version version, ReferenceResolver referenceResolver, ValueConverter valueConverter, WarningListener<?> warningListener) {
        this.bitMasks = n;
        this.locale = locale;
        this.timezone = timeZone;
        this.schemas = map;
        this.versionGML = version;
        this.resolver = referenceResolver;
        this.converter = valueConverter;
        this.warningListener = warningListener;
        this.previous = Context.current();
        CURRENT.set(this);
        if ((n & 1) != 0 && !Semaphores.queryAndSet((byte)4)) {
            this.bitMasks |= 0x20;
        }
    }

    private Context(Context context) {
        if (context != null) {
            this.bitMasks = context.bitMasks;
            this.locale = context.locale;
            this.timezone = context.timezone;
            this.schemas = context.schemas;
            this.versionGML = context.versionGML;
            this.resolver = context.resolver;
            this.converter = context.converter;
            this.warningListener = context.warningListener;
        }
        this.previous = context;
        CURRENT.set(this);
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    @Override
    public final Version getVersion(String string) {
        if (string.equals("gml")) {
            return this.versionGML;
        }
        return null;
    }

    public static Context current() {
        return CURRENT.get();
    }

    public static boolean isFlagSet(Context context, int n) {
        return context != null && (context.bitMasks & n) != 0;
    }

    public static StringBuilder schema(Context context, String string, String string2) {
        String string3;
        Map<String, String> map;
        StringBuilder stringBuilder = new StringBuilder(128);
        if (context != null && (map = context.schemas) != null && (string3 = map.get(string)) != null) {
            string2 = string3;
        }
        stringBuilder.append(string2);
        int n = stringBuilder.length();
        if (n != 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append('/');
        }
        return stringBuilder;
    }

    public static boolean isGMLVersion(Context context, Version version) {
        Version version2;
        if (context != null && (version2 = context.versionGML) != null) {
            return version2.compareTo(version) >= 0;
        }
        return true;
    }

    public static ReferenceResolver resolver(Context context) {
        ReferenceResolver referenceResolver;
        if (context != null && (referenceResolver = context.resolver) != null) {
            return referenceResolver;
        }
        return ReferenceResolver.DEFAULT;
    }

    public static ValueConverter converter(Context context) {
        ValueConverter valueConverter;
        if (context != null && (valueConverter = context.converter) != null) {
            return valueConverter;
        }
        return ValueConverter.DEFAULT;
    }

    public static void warningOccured(Context context, Logger logger, Level level, Class<?> clazz, String string, Throwable throwable, Class<? extends IndexedResourceBundle> clazz2, short s, Object ... objectArray) {
        LogRecord logRecord;
        Object object;
        Locale locale;
        Locale locale2 = locale = context != null ? context.getLocale() : null;
        if (clazz2 != null) {
            if (clazz2 == Errors.class) {
                object = Errors.getResources(locale);
            } else if (clazz2 == Messages.class) {
                object = Messages.getResources(locale);
            } else {
                throw new IllegalArgumentException(String.valueOf(clazz2));
            }
            logRecord = ((IndexedResourceBundle)object).getLogRecord(level, s, objectArray);
        } else {
            logRecord = new LogRecord(level, Exceptions.formatChainedMessages(locale, null, throwable));
        }
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName(logger.getName());
        if (context != null && (object = context.warningListener) != null) {
            logRecord.setThrown(throwable);
            object.warningOccured(null, logRecord);
            return;
        }
        logger.log(logRecord);
    }

    public static void warningOccured(Context context, Logger logger, Class<?> clazz, String string, Class<? extends IndexedResourceBundle> clazz2, short s, Object ... objectArray) {
        Context.warningOccured(context, logger, Level.WARNING, clazz, string, null, clazz2, s, objectArray);
    }

    public static void warningOccured(Context context, Class<?> clazz, String string, Exception exception, boolean bl) {
        Context.warningOccured(context, LOGGER, bl ? Level.WARNING : Level.FINE, clazz, string, exception, null, (short)0, (Object[])null);
    }

    public static void push(Locale locale) {
        Context context = new Context(Context.current());
        if (locale != null) {
            context.locale = locale;
        }
    }

    public static void pull() {
        Context context = Context.current();
        if (context != null) {
            context.finish();
        }
    }

    public final void finish() {
        if ((this.bitMasks & 0x20) != 0) {
            Semaphores.clear((byte)4);
        }
        if (this.previous != null) {
            CURRENT.set(this.previous);
        } else {
            CURRENT.remove();
        }
    }
}

