/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Locales;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.AbstractInternationalString;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.util.InternationalString;

public class DefaultInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 3663160836923279819L;
    private Map<Locale, String> localeMap;
    private transient Set<Locale> localeSet;

    public DefaultInternationalString() {
        this.localeMap = Collections.emptyMap();
    }

    public DefaultInternationalString(String string) {
        this.localeMap = string != null ? Collections.singletonMap(Locale.ROOT, string) : Collections.emptyMap();
    }

    public DefaultInternationalString(Map<Locale, String> map) {
        if (Containers.isNullOrEmpty(map)) {
            this.localeMap = Collections.emptyMap();
        } else {
            Iterator<Map.Entry<Locale, String>> iterator = map.entrySet().iterator();
            Map.Entry<Locale, String> entry = iterator.next();
            this.localeMap = !iterator.hasNext() ? Collections.singletonMap(entry.getKey(), entry.getValue()) : new LinkedHashMap<Locale, String>(map);
        }
        boolean bl = this.localeMap.containsKey(null);
        if (bl || this.localeMap.containsValue(null)) {
            throw new IllegalArgumentException(Errors.format(bl ? (short)96 : 97));
        }
    }

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("locale", locale);
        ArgumentChecks.ensureNonNull("string", string);
        switch (this.localeMap.size()) {
            case 0: {
                this.localeMap = Collections.singletonMap(locale, string);
                this.localeSet = null;
                this.defaultValue = null;
                return;
            }
            case 1: {
                this.localeMap = new LinkedHashMap<Locale, String>(this.localeMap);
                this.localeSet = null;
            }
        }
        String string2 = this.localeMap.put(locale, string);
        if (string2 != null) {
            this.localeMap.put(locale, string2);
            if (string.equals(string2)) {
                return;
            }
            throw new IllegalArgumentException(Errors.format((short)131, locale));
        }
        this.defaultValue = null;
    }

    final void add(Locale locale, CharSequence charSequence) throws IllegalArgumentException {
        boolean bl = charSequence instanceof InternationalString;
        this.add(locale, bl ? ((InternationalString)charSequence).toString(locale) : charSequence.toString());
        if (bl && !(charSequence instanceof SimpleInternationalString)) {
            LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.WARNING, (short)3);
            logRecord.setSourceClassName("org.apache.sis.util.iso.Types");
            logRecord.setSourceMethodName("toInternationalString");
            logRecord.setLoggerName("org.apache.sis.util.iso");
            Logging.getLogger("org.apache.sis.util.iso").log(logRecord);
        }
    }

    public synchronized Set<Locale> getLocales() {
        Set<Locale> set = this.localeSet;
        if (set == null) {
            set = this.localeMap.keySet();
            if (this.localeMap instanceof HashMap) {
                set = Collections.unmodifiableSet(set);
            }
            this.localeSet = set;
        }
        return set;
    }

    private String getString(Locale locale) {
        while (locale != null) {
            String string = this.localeMap.get(locale);
            if (string != null) {
                return string;
            }
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = locale.getVariant();
            if (!string4.isEmpty()) {
                locale = new Locale(string2, string3);
                continue;
            }
            if (string3.isEmpty()) break;
            locale = new Locale(string2);
        }
        return null;
    }

    @Override
    public synchronized String toString(Locale locale) {
        String string = this.getString(locale);
        if (string == null && (string = this.localeMap.get(Locale.ROOT)) == null) {
            Locale locale2 = Locale.US;
            if (locale2 != locale && (string = this.getString(locale2)) != null) {
                return string;
            }
            locale2 = Locale.getDefault();
            if (locale2 != locale && locale2 != Locale.US && (string = this.getString(locale2)) != null) {
                return string;
            }
            Iterator<String> iterator = this.localeMap.values().iterator();
            if (iterator.hasNext()) {
                string = iterator.next();
            }
        }
        return string;
    }

    public synchronized boolean isSubsetOf(Object object) {
        if (object instanceof InternationalString) {
            InternationalString internationalString = (InternationalString)object;
            for (Map.Entry<Locale, String> entry : this.localeMap.entrySet()) {
                Locale locale = entry.getKey();
                String string = entry.getValue();
                if (string.equals(internationalString.toString(locale))) continue;
                return false;
            }
        } else if (object instanceof CharSequence) {
            String string = object.toString();
            for (String string2 : this.localeMap.values()) {
                if (string2.equals(string)) continue;
                return false;
            }
        } else {
            if (object instanceof Map) {
                Map map = (Map)object;
                return map.entrySet().containsAll(this.localeMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DefaultInternationalString defaultInternationalString = (DefaultInternationalString)object;
            return Objects.equals(this.localeMap, defaultInternationalString.localeMap);
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.localeMap.hashCode() ^ 0x77EF49CB;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.localeMap.size();
        if (n == 0) {
            return;
        }
        Map.Entry[] entryArray = new Map.Entry[n];
        entryArray = this.localeMap.entrySet().toArray(entryArray);
        if (n == 1) {
            Map.Entry entry = entryArray[0];
            this.localeMap = Collections.singletonMap(Locales.unique((Locale)entry.getKey()), entry.getValue());
        } else {
            this.localeMap.clear();
            for (Map.Entry entry : entryArray) {
                this.localeMap.put(Locales.unique((Locale)entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

