/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.simple.SimpleAttributeType;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultRecordType;
import org.apache.sis.util.iso.TypeNames;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

public class DefaultRecordSchema
implements RecordSchema {
    protected final DefaultNameFactory nameFactory;
    private final TypeNames typeFactory;
    private final NameSpace namespace;
    private final Map<TypeName, RecordType> description;
    private final ConcurrentMap<Class<?>, Type> attributeTypes;
    private final ObjectConverter<Class<?>, Type> toTypes = new SurjectiveConverter<Class<?>, Type>(){

        @Override
        public Class<Class<?>> getSourceClass() {
            return Class.class;
        }

        @Override
        public Class<Type> getTargetClass() {
            return Type.class;
        }

        @Override
        public Type apply(Class<?> clazz) {
            return DefaultRecordSchema.this.toAttributeType(clazz);
        }
    };

    public DefaultRecordSchema(DefaultNameFactory defaultNameFactory, NameSpace nameSpace, CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("schemaName", charSequence);
        if (defaultNameFactory == null) {
            defaultNameFactory = DefaultFactories.NAMES;
        }
        this.nameFactory = defaultNameFactory;
        this.typeFactory = defaultNameFactory instanceof DefaultNameFactory ? null : new TypeNames(defaultNameFactory);
        this.namespace = defaultNameFactory.createNameSpace(defaultNameFactory.createLocalName(nameSpace, charSequence), null);
        this.description = new WeakValueHashMap<TypeName, RecordType>(TypeName.class);
        this.attributeTypes = new ConcurrentHashMap();
    }

    @Override
    public LocalName getSchemaName() {
        return this.namespace.name().tip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordType createRecordType(CharSequence charSequence, Map<CharSequence, Class<?>> map) throws IllegalArgumentException {
        boolean bl;
        RecordType recordType;
        ArgumentChecks.ensureNonNull("typeName", charSequence);
        ArgumentChecks.ensureNonNull("members", map);
        TypeName typeName = this.nameFactory.createTypeName(this.namespace, charSequence);
        Map<CharSequence, Type> map2 = ObjectConverters.derivedValues(map, CharSequence.class, this.toTypes);
        Object object = this.description;
        synchronized (object) {
            recordType = this.description.get(charSequence);
            if (recordType == null) {
                recordType = new DefaultRecordType(typeName, this, map2, this.nameFactory);
                this.description.put(typeName, recordType);
                return recordType;
            }
        }
        object = map.entrySet().iterator();
        Iterator<Map.Entry<MemberName, Type>> iterator = recordType.getMemberTypes().entrySet().iterator();
        while ((bl = object.hasNext()) == iterator.hasNext()) {
            if (!bl) {
                return recordType;
            }
            Map.Entry entry = (Map.Entry)object.next();
            Map.Entry<MemberName, Type> entry2 = iterator.next();
            if (entry2.getKey().tip().toString().equals(entry.toString()) && ((SimpleAttributeType)entry2.getValue()).getValueClass().equals(entry.getValue())) continue;
            break;
        }
        throw new IllegalArgumentException(Errors.format((short)161, this.getSchemaName(), charSequence));
    }

    final Type toAttributeType(Class<?> clazz) {
        if (!TypeNames.isValid(clazz)) {
            return null;
        }
        SimpleAttributeType simpleAttributeType = (SimpleAttributeType)this.attributeTypes.get(clazz);
        if (simpleAttributeType == null) {
            if (clazz == Void.TYPE) {
                throw new IllegalArgumentException(Errors.format((short)31, "valueClass", "void"));
            }
            TypeName typeName = this.nameFactory.toTypeName(clazz);
            simpleAttributeType = new SimpleAttributeType(typeName, clazz);
            Type type = this.attributeTypes.putIfAbsent(clazz, simpleAttributeType);
            if (type != null) {
                return type;
            }
        }
        return simpleAttributeType;
    }

    @Override
    public Map<TypeName, RecordType> getDescription() {
        return Collections.unmodifiableMap(this.description);
    }

    @Override
    public RecordType locate(TypeName typeName) {
        return this.description.get(typeName);
    }

    public String toString() {
        return "RecordSchema[\u201c" + this.getSchemaName() + "\u201d]";
    }
}

