/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.xml.MarshallerPool;

public final class XML
extends Static {
    public static final String LOCALE = "org.apache.sis.xml.locale";
    public static final String TIMEZONE = "org.apache.sis.xml.timezone";
    public static final String SCHEMAS = "org.apache.sis.xml.schemas";
    public static final String DEFAULT_NAMESPACE = "org.apache.sis.xml.defaultNamespace";
    public static final String GML_VERSION = "org.apache.sis.gml.version";
    public static final String RESOLVER = "org.apache.sis.xml.resolver";
    public static final String CONVERTER = "org.apache.sis.xml.converter";
    public static final String STRING_SUBSTITUTES = "org.apache.sis.xml.stringSubstitutes";
    public static final String WARNING_LISTENER = "org.apache.sis.xml.warningListener";
    private static volatile MarshallerPool POOL;

    private XML() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MarshallerPool getPool() throws JAXBException {
        MarshallerPool marshallerPool = POOL;
        if (marshallerPool != null) return marshallerPool;
        Class<XML> clazz = XML.class;
        synchronized (XML.class) {
            marshallerPool = POOL;
            if (marshallerPool != null) return marshallerPool;
            POOL = marshallerPool = new MarshallerPool(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return marshallerPool;
        }
    }

    public static String marshal(Object object) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        StringWriter stringWriter = new StringWriter();
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        marshaller.marshal(object, (Writer)stringWriter);
        marshallerPool.recycle(marshaller);
        return stringWriter.toString();
    }

    public static void marshal(Object object, OutputStream outputStream) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("output", outputStream);
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        marshaller.marshal(object, outputStream);
        marshallerPool.recycle(marshaller);
    }

    public static void marshal(Object object, File file) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("output", file);
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        marshaller.marshal(object, file);
        marshallerPool.recycle(marshaller);
    }

    public static void marshal(Object object, Result result, Map<String, ?> map) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("output", result);
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                marshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        marshaller.marshal(object, result);
        marshallerPool.recycle(marshaller);
    }

    public static Object unmarshal(String string) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", string);
        StringReader stringReader = new StringReader(string);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal((Reader)stringReader);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(InputStream inputStream) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", inputStream);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(inputStream);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(URL uRL) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", uRL);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(uRL);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(File file) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", file);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(file);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(Source source, Map<String, ?> map) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", source);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                unmarshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        Object object = unmarshaller.unmarshal(source);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.utility"){

            @Override
            protected void classpathChanged() {
                POOL = null;
            }
        });
    }
}

