/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.FreeformShape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public final class HSLFFreeformShape
extends HSLFAutoShape
implements FreeformShape<HSLFShape, HSLFTextParagraph> {
    public static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    public static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    public static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    public static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    public static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    public static final byte[] SEGMENTINFO_CUBICTO2 = new byte[]{0, -77};
    public static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    public static final byte[] SEGMENTINFO_END = new byte[]{0, -128};

    protected HSLFFreeformShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFFreeformShape(ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super((EscherContainerRecord)null, parent);
        this._escherContainer = this.createSpContainer(ShapeType.NOT_PRIMITIVE, parent instanceof HSLFGroupShape);
    }

    public HSLFFreeformShape() {
        this((ShapeContainer<HSLFShape, HSLFTextParagraph>)null);
    }

    public int setPath(GeneralPath path) {
        Rectangle bounds = path.getBounds();
        PathIterator it = path.getPathIterator(new AffineTransform());
        ArrayList<byte[]> segInfo = new ArrayList<byte[]>();
        ArrayList<Point2D.Double> pntInfo = new ArrayList<Point2D.Double>();
        boolean isClosed = false;
        int numPoints = 0;
        while (!it.isDone()) {
            double[] vals = new double[6];
            int type = it.currentSegment(vals);
            switch (type) {
                case 0: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(SEGMENTINFO_MOVETO);
                    ++numPoints;
                    break;
                }
                case 1: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_ESCAPE);
                    ++numPoints;
                    break;
                }
                case 3: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    pntInfo.add(new Point2D.Double(vals[2], vals[3]));
                    pntInfo.add(new Point2D.Double(vals[4], vals[5]));
                    segInfo.add(SEGMENTINFO_CUBICTO);
                    segInfo.add(SEGMENTINFO_ESCAPE2);
                    ++numPoints;
                    break;
                }
                case 2: {
                    this.logger.log(5, new Object[]{"SEG_QUADTO is not supported"});
                    break;
                }
                case 4: {
                    pntInfo.add((Point2D.Double)pntInfo.get(0));
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_ESCAPE);
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_CLOSE);
                    isClosed = true;
                    ++numPoints;
                }
            }
            it.next();
        }
        if (!isClosed) {
            segInfo.add(SEGMENTINFO_LINETO);
        }
        segInfo.add(new byte[]{0, -128});
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = new EscherArrayProperty(16709, false, null);
        verticesProp.setNumberOfElementsInArray(pntInfo.size());
        verticesProp.setNumberOfElementsInMemory(pntInfo.size());
        verticesProp.setSizeOfElements(65520);
        for (int i = 0; i < pntInfo.size(); ++i) {
            Point2D.Double pnt = (Point2D.Double)pntInfo.get(i);
            byte[] data = new byte[4];
            LittleEndian.putShort((byte[])data, (int)0, (short)((short)Units.pointsToMaster((double)(pnt.getX() - bounds.getX()))));
            LittleEndian.putShort((byte[])data, (int)2, (short)((short)Units.pointsToMaster((double)(pnt.getY() - bounds.getY()))));
            verticesProp.setElement(i, data);
        }
        opt.addEscherProperty((EscherProperty)verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(16710, false, null);
        segmentsProp.setNumberOfElementsInArray(segInfo.size());
        segmentsProp.setNumberOfElementsInMemory(segInfo.size());
        segmentsProp.setSizeOfElements(2);
        for (int i = 0; i < segInfo.size(); ++i) {
            byte[] seg = (byte[])segInfo.get(i);
            segmentsProp.setElement(i, seg);
        }
        opt.addEscherProperty((EscherProperty)segmentsProp);
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(322, Units.pointsToMaster((double)bounds.getWidth())));
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(323, Units.pointsToMaster((double)bounds.getHeight())));
        opt.sortProperties();
        this.setAnchor(bounds);
        return numPoints;
    }

    public GeneralPath getPath() {
        EscherArrayProperty segmentsProp;
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(opt, 16709);
        if (verticesProp == null) {
            verticesProp = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(opt, 325);
        }
        if ((segmentsProp = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(opt, 16710)) == null) {
            segmentsProp = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(opt, 326);
        }
        GeneralPath path = new GeneralPath();
        if (verticesProp == null) {
            this.logger.log(5, new Object[]{"Freeform is missing GEOMETRY__VERTICES "});
            return path;
        }
        if (segmentsProp == null) {
            this.logger.log(5, new Object[]{"Freeform is missing GEOMETRY__SEGMENTINFO "});
            return path;
        }
        int numPoints = verticesProp.getNumberOfElementsInArray();
        int numSegments = segmentsProp.getNumberOfElementsInArray();
        int j = 0;
        for (int i = 0; i < numSegments && j < numPoints; ++i) {
            byte[] pnext;
            byte[] elem = segmentsProp.getElement(i);
            if (Arrays.equals(elem, SEGMENTINFO_MOVETO)) {
                byte[] p = verticesProp.getElement(j++);
                short x = LittleEndian.getShort((byte[])p, (int)0);
                short y = LittleEndian.getShort((byte[])p, (int)2);
                path.moveTo(Units.masterToPoints((int)x), Units.masterToPoints((int)y));
                continue;
            }
            if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2)) {
                ++i;
                byte[] p1 = verticesProp.getElement(j++);
                short x1 = LittleEndian.getShort((byte[])p1, (int)0);
                short y1 = LittleEndian.getShort((byte[])p1, (int)2);
                byte[] p2 = verticesProp.getElement(j++);
                short x2 = LittleEndian.getShort((byte[])p2, (int)0);
                short y2 = LittleEndian.getShort((byte[])p2, (int)2);
                byte[] p3 = verticesProp.getElement(j++);
                short x3 = LittleEndian.getShort((byte[])p3, (int)0);
                short y3 = LittleEndian.getShort((byte[])p3, (int)2);
                path.curveTo(Units.masterToPoints((int)x1), Units.masterToPoints((int)y1), Units.masterToPoints((int)x2), Units.masterToPoints((int)y2), Units.masterToPoints((int)x3), Units.masterToPoints((int)y3));
                continue;
            }
            if (!Arrays.equals(elem, SEGMENTINFO_LINETO)) continue;
            if (Arrays.equals(pnext = segmentsProp.getElement(++i), SEGMENTINFO_ESCAPE)) {
                if (j + 1 >= numPoints) continue;
                byte[] p = verticesProp.getElement(j++);
                short x = LittleEndian.getShort((byte[])p, (int)0);
                short y = LittleEndian.getShort((byte[])p, (int)2);
                path.lineTo(Units.masterToPoints((int)x), Units.masterToPoints((int)y));
                continue;
            }
            if (!Arrays.equals(pnext, SEGMENTINFO_CLOSE)) continue;
            path.closePath();
        }
        Rectangle anchor = this.getAnchor();
        Rectangle2D bounds = path.getBounds2D();
        AffineTransform at = new AffineTransform();
        at.translate(((RectangularShape)anchor).getX(), ((RectangularShape)anchor).getY());
        at.scale(((RectangularShape)anchor).getWidth() / bounds.getWidth(), ((RectangularShape)anchor).getHeight() / bounds.getHeight());
        return new GeneralPath(at.createTransformedShape(path));
    }
}

