/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Rectangle;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.usermodel.HSLFLine;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.TableCell;

public final class HSLFTableCell
extends HSLFTextBox
implements TableCell<HSLFShape, HSLFTextParagraph> {
    protected static final int DEFAULT_WIDTH = 100;
    protected static final int DEFAULT_HEIGHT = 40;
    private HSLFLine borderLeft;
    private HSLFLine borderRight;
    private HSLFLine borderTop;
    private HSLFLine borderBottom;

    protected HSLFTableCell(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFTableCell(ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(parent);
        this.setShapeType(ShapeType.RECT);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        this._escherContainer = super.createSpContainer(isChild);
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFTableCell.setEscherProperty(opt, (short)128, 0);
        HSLFTableCell.setEscherProperty(opt, (short)191, 131072);
        HSLFTableCell.setEscherProperty(opt, (short)447, 0x150001);
        HSLFTableCell.setEscherProperty(opt, (short)575, 131072);
        HSLFTableCell.setEscherProperty(opt, (short)127, 262144);
        return this._escherContainer;
    }

    protected void anchorBorder(int type, HSLFLine line) {
        Rectangle cellAnchor = this.getAnchor();
        Rectangle lineAnchor = new Rectangle();
        switch (type) {
            case 1: {
                lineAnchor.x = cellAnchor.x;
                lineAnchor.y = cellAnchor.y;
                lineAnchor.width = cellAnchor.width;
                lineAnchor.height = 0;
                break;
            }
            case 2: {
                lineAnchor.x = cellAnchor.x + cellAnchor.width;
                lineAnchor.y = cellAnchor.y;
                lineAnchor.width = 0;
                lineAnchor.height = cellAnchor.height;
                break;
            }
            case 3: {
                lineAnchor.x = cellAnchor.x;
                lineAnchor.y = cellAnchor.y + cellAnchor.height;
                lineAnchor.width = cellAnchor.width;
                lineAnchor.height = 0;
                break;
            }
            case 4: {
                lineAnchor.x = cellAnchor.x;
                lineAnchor.y = cellAnchor.y;
                lineAnchor.width = 0;
                lineAnchor.height = cellAnchor.height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown border type: " + type);
            }
        }
        line.setAnchor(lineAnchor);
    }

    public HSLFLine getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(HSLFLine line) {
        if (line != null) {
            this.anchorBorder(4, line);
        }
        this.borderLeft = line;
    }

    public HSLFLine getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(HSLFLine line) {
        if (line != null) {
            this.anchorBorder(2, line);
        }
        this.borderRight = line;
    }

    public HSLFLine getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(HSLFLine line) {
        if (line != null) {
            this.anchorBorder(1, line);
        }
        this.borderTop = line;
    }

    public HSLFLine getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(HSLFLine line) {
        if (line != null) {
            this.anchorBorder(3, line);
        }
        this.borderBottom = line;
    }

    @Override
    public void setAnchor(Rectangle anchor) {
        super.setAnchor(anchor);
        if (this.borderTop != null) {
            this.anchorBorder(1, this.borderTop);
        }
        if (this.borderRight != null) {
            this.anchorBorder(2, this.borderRight);
        }
        if (this.borderBottom != null) {
            this.anchorBorder(3, this.borderBottom);
        }
        if (this.borderLeft != null) {
            this.anchorBorder(4, this.borderLeft);
        }
    }
}

