/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_ImageDescription;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.ImagingCondition;

@XmlType(name="MD_ImageDescription_Type", propOrder={"illuminationElevationAngle", "illuminationAzimuthAngle", "imagingCondition", "imageQualityCode", "cloudCoverPercentage", "processingLevelCode", "compressionGenerationQuantity", "triangulationIndicator", "radiometricCalibrationDataAvailable", "cameraCalibrationInformationAvailable", "filmDistortionInformationAvailable", "lensDistortionInformationAvailable"})
@XmlRootElement(name="MD_ImageDescription")
@XmlSeeAlso(value={MI_ImageDescription.class})
public class DefaultImageDescription
extends DefaultCoverageDescription
implements ImageDescription {
    private static final long serialVersionUID = -239683653229623567L;
    private Double illuminationElevationAngle;
    private Double illuminationAzimuthAngle;
    private ImagingCondition imagingCondition;
    private Identifier imageQualityCode;
    private Double cloudCoverPercentage;
    private Integer compressionGenerationQuantity;
    private Boolean triangulationIndicator;
    private Boolean radiometricCalibrationDataAvailable;
    private Boolean cameraCalibrationInformationAvailable;
    private Boolean filmDistortionInformationAvailable;
    private Boolean lensDistortionInformationAvailable;

    public DefaultImageDescription() {
    }

    public DefaultImageDescription(ImageDescription imageDescription) {
        super(imageDescription);
        if (imageDescription != null) {
            this.illuminationElevationAngle = imageDescription.getIlluminationElevationAngle();
            this.illuminationAzimuthAngle = imageDescription.getIlluminationAzimuthAngle();
            this.imagingCondition = imageDescription.getImagingCondition();
            this.imageQualityCode = imageDescription.getImageQualityCode();
            this.cloudCoverPercentage = imageDescription.getCloudCoverPercentage();
            this.compressionGenerationQuantity = imageDescription.getCompressionGenerationQuantity();
            this.triangulationIndicator = imageDescription.getTriangulationIndicator();
            this.radiometricCalibrationDataAvailable = imageDescription.isRadiometricCalibrationDataAvailable();
            this.cameraCalibrationInformationAvailable = imageDescription.isCameraCalibrationInformationAvailable();
            this.filmDistortionInformationAvailable = imageDescription.isFilmDistortionInformationAvailable();
            this.lensDistortionInformationAvailable = imageDescription.isLensDistortionInformationAvailable();
        }
    }

    public static DefaultImageDescription castOrCopy(ImageDescription imageDescription) {
        if (imageDescription == null || imageDescription instanceof DefaultImageDescription) {
            return (DefaultImageDescription)imageDescription;
        }
        return new DefaultImageDescription(imageDescription);
    }

    private static void ensureInRange(String string, double d, double d2, Double d3) throws IllegalArgumentException {
        double d4;
        if (!(d3 == null || (d4 = d3.doubleValue()) >= d && d4 <= d2)) {
            MetadataUtilities.warnOutOfRangeArgument(DefaultImageDescription.class, string, d, d2, d4);
        }
    }

    @Override
    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="illuminationElevationAngle")
    public Double getIlluminationElevationAngle() {
        return this.illuminationElevationAngle;
    }

    public void setIlluminationElevationAngle(Double d) {
        this.checkWritePermission();
        DefaultImageDescription.ensureInRange("illuminationElevationAngle", -90.0, 90.0, d);
        this.illuminationElevationAngle = d;
    }

    @Override
    @ValueRange(minimum=0.0, maximum=360.0)
    @XmlElement(name="illuminationAzimuthAngle")
    public Double getIlluminationAzimuthAngle() {
        return this.illuminationAzimuthAngle;
    }

    public void setIlluminationAzimuthAngle(Double d) {
        this.checkWritePermission();
        DefaultImageDescription.ensureInRange("illuminationAzimuthAngle", 0.0, 360.0, d);
        this.illuminationAzimuthAngle = d;
    }

    @Override
    @XmlElement(name="imagingCondition")
    public ImagingCondition getImagingCondition() {
        return this.imagingCondition;
    }

    public void setImagingCondition(ImagingCondition imagingCondition) {
        this.checkWritePermission();
        this.imagingCondition = imagingCondition;
    }

    @Override
    @XmlElement(name="imageQualityCode")
    public Identifier getImageQualityCode() {
        return this.imageQualityCode;
    }

    public void setImageQualityCode(Identifier identifier) {
        this.checkWritePermission();
        this.imageQualityCode = identifier;
    }

    @Override
    @ValueRange(minimum=0.0, maximum=100.0)
    @XmlElement(name="cloudCoverPercentage")
    public Double getCloudCoverPercentage() {
        return this.cloudCoverPercentage;
    }

    public void setCloudCoverPercentage(Double d) {
        this.checkWritePermission();
        DefaultImageDescription.ensureInRange("cloudCoverPercentage", 0.0, 100.0, d);
        this.cloudCoverPercentage = d;
    }

    @Override
    @XmlElement(name="processingLevelCode")
    public Identifier getProcessingLevelCode() {
        return super.getProcessingLevelCode();
    }

    @Override
    public void setProcessingLevelCode(Identifier identifier) {
        super.setProcessingLevelCode(identifier);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="compressionGenerationQuantity")
    public Integer getCompressionGenerationQuantity() {
        return this.compressionGenerationQuantity;
    }

    public void setCompressionGenerationQuantity(Integer n) {
        this.checkWritePermission();
        if (n != null && n < 0) {
            MetadataUtilities.warnNonPositiveArgument(DefaultImageDescription.class, "compressionGenerationQuantity", false, n);
        }
        this.compressionGenerationQuantity = n;
    }

    @Override
    @XmlElement(name="triangulationIndicator")
    public Boolean getTriangulationIndicator() {
        return this.triangulationIndicator;
    }

    public void setTriangulationIndicator(Boolean bl) {
        this.checkWritePermission();
        this.triangulationIndicator = bl;
    }

    @Override
    @XmlElement(name="radiometricCalibrationDataAvailability")
    public Boolean isRadiometricCalibrationDataAvailable() {
        return this.radiometricCalibrationDataAvailable;
    }

    public void setRadiometricCalibrationDataAvailable(Boolean bl) {
        this.checkWritePermission();
        this.radiometricCalibrationDataAvailable = bl;
    }

    @Override
    @XmlElement(name="cameraCalibrationInformationAvailability")
    public Boolean isCameraCalibrationInformationAvailable() {
        return this.cameraCalibrationInformationAvailable;
    }

    public void setCameraCalibrationInformationAvailable(Boolean bl) {
        this.checkWritePermission();
        this.cameraCalibrationInformationAvailable = bl;
    }

    @Override
    @XmlElement(name="filmDistortionInformationAvailability")
    public Boolean isFilmDistortionInformationAvailable() {
        return this.filmDistortionInformationAvailable;
    }

    public void setFilmDistortionInformationAvailable(Boolean bl) {
        this.checkWritePermission();
        this.filmDistortionInformationAvailable = bl;
    }

    @Override
    @XmlElement(name="lensDistortionInformationAvailability")
    public Boolean isLensDistortionInformationAvailable() {
        return this.lensDistortionInformationAvailable;
    }

    public void setLensDistortionInformationAvailable(Boolean bl) {
        this.checkWritePermission();
        this.lensDistortionInformationAvailable = bl;
    }
}

