/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;

abstract class MimeTypeDetector {
    private static final Map<String, String> TYPES = new HashMap<String, String>();
    private static byte[] XMLNS;
    private static final int MAX_ASCII = 126;
    private byte[] buffer = new byte[32];
    private int length;
    boolean insufficientBytes;

    MimeTypeDetector() {
    }

    private void add(int n) {
        if (this.length == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.length * 2);
        }
        this.buffer[this.length++] = (byte)n;
    }

    abstract int read() throws IOException;

    private int readAfter(int n) throws IOException {
        int n2;
        boolean bl = false;
        while ((n2 = this.read()) >= 0) {
            if (n2 == 34) {
                bl = !bl;
                continue;
            }
            if (n2 != n || bl) continue;
            return this.read();
        }
        return -1;
    }

    private int afterSpaces(int n) throws IOException {
        while (n <= 32 && n >= 0) {
            n = this.read();
        }
        return n;
    }

    private int matches(byte[] byArray, int n, char c) throws IOException {
        int n2 = this.afterSpaces(this.read());
        for (int i = 0; i < n; ++i) {
            if (n2 != byArray[i]) {
                return n2 >= 0 ? 0 : -1;
            }
            n2 = this.read();
        }
        return (n2 = this.afterSpaces(n2)) == c ? 1 : (n2 >= 0 ? 0 : -1);
    }

    final String getMimeType() throws IOException {
        int n;
        block16: {
            if (this.readAfter(63) != 62) {
                return null;
            }
            while ((n = this.readAfter(60)) == 33) {
                do {
                    n = this.readAfter(45);
                    while (n == 45) {
                        n = this.read();
                    }
                    if (n >= 0) continue;
                    return null;
                } while (n != 62);
            }
            n = this.afterSpaces(n);
            while (n > 32 && n != 58) {
                if (n == 62 || n > 126) {
                    return null;
                }
                this.add(n);
                n = this.read();
            }
            if ((n = this.afterSpaces(n)) != 58) {
                return null;
            }
            do {
                int n2;
                if ((n2 = this.matches(XMLNS, XMLNS.length, ':')) != 0) {
                    if (n2 < 0) {
                        return null;
                    }
                    n2 = this.matches(this.buffer, this.length, '=');
                    if (n2 != 0) {
                        if (n2 < 0) {
                            return null;
                        }
                        break block16;
                    }
                }
                while ((n = this.read()) >= 32) {
                }
            } while (n >= 0);
            return null;
        }
        this.length = 0;
        n = this.afterSpaces(this.read());
        if (n != 34) {
            return null;
        }
        n = this.afterSpaces(this.read());
        do {
            if (n < 0 || n > 126) {
                return null;
            }
            this.add(n);
        } while ((n = this.read()) != 34);
        return TYPES.get(new String(this.buffer, 0, this.length, "US-ASCII"));
    }

    final ProbeResult probeContent() throws DataStoreException {
        String string;
        try {
            string = this.getMimeType();
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        if (string == null) {
            if (this.insufficientBytes) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            string = "application/xml";
        }
        return new ProbeResult(true, string, null);
    }

    static {
        TYPES.put("http://www.opengis.net/gml/3.2", "application/gml+xml");
        TYPES.put("http://www.isotc211.org/2005/gmd", "application/vnd.iso.19139+xml");
        TYPES.put("http://www.opengis.net/cat/csw/2.0.2", "application/vnd.ogc.csw_xml");
        XMLNS = new byte[]{120, 109, 108, 110, 115};
    }
}

