/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.CountUtils;
import org.apache.poi.ss.formula.functions.Countif;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

public final class Sumifs
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Sumifs();

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length < 3 || args.length % 2 == 0) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            AreaEval sumRange = Sumifs.convertRangeArg(args[0]);
            AreaEval[] ae = new AreaEval[(args.length - 1) / 2];
            CountUtils.I_MatchPredicate[] mp = new CountUtils.I_MatchPredicate[ae.length];
            int i = 1;
            int k = 0;
            while (i < args.length) {
                ae[k] = Sumifs.convertRangeArg(args[i]);
                mp[k] = Countif.createCriteriaPredicate(args[i + 1], ec.getRowIndex(), ec.getColumnIndex());
                i += 2;
                ++k;
            }
            this.validateCriteriaRanges(ae, sumRange);
            this.validateCriteria(mp);
            double result = Sumifs.sumMatchingCells(ae, mp, sumRange);
            return new NumberEval(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private void validateCriteriaRanges(AreaEval[] criteriaRanges, AreaEval sumRange) throws EvaluationException {
        for (AreaEval r : criteriaRanges) {
            if (r.getHeight() == sumRange.getHeight() && r.getWidth() == sumRange.getWidth()) continue;
            throw EvaluationException.invalidValue();
        }
    }

    private void validateCriteria(CountUtils.I_MatchPredicate[] criteria) throws EvaluationException {
        for (CountUtils.I_MatchPredicate predicate : criteria) {
            if (!(predicate instanceof Countif.ErrorMatcher)) continue;
            throw new EvaluationException(ErrorEval.valueOf(((Countif.ErrorMatcher)predicate).getValue()));
        }
    }

    private static double sumMatchingCells(AreaEval[] ranges, CountUtils.I_MatchPredicate[] predicates, AreaEval aeSum) {
        int height = aeSum.getHeight();
        int width = aeSum.getWidth();
        double result = 0.0;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                boolean matches = true;
                for (int i = 0; i < ranges.length; ++i) {
                    CountUtils.I_MatchPredicate mp = predicates[i];
                    AreaEval aeRange = ranges[i];
                    if (mp.matches(aeRange.getRelativeValue(r, c))) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                result += Sumifs.accumulate(aeSum, r, c);
            }
        }
        return result;
    }

    private static double accumulate(AreaEval aeSum, int relRowIndex, int relColIndex) {
        ValueEval addend = aeSum.getRelativeValue(relRowIndex, relColIndex);
        if (addend instanceof NumberEval) {
            return ((NumberEval)addend).getNumberValue();
        }
        return 0.0;
    }

    private static AreaEval convertRangeArg(ValueEval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            return ((RefEval)eval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

