/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;

public class TextSpecInfoRun {
    private static final BitField spellFld = new BitField(1);
    private static final BitField langFld = new BitField(2);
    private static final BitField altLangFld = new BitField(4);
    private static final BitField pp10extFld = new BitField(32);
    private static final BitField bidiFld = new BitField(64);
    private static final BitField smartTagFld = new BitField(512);
    private static final BitField pp10runidFld = new BitField(15);
    private static final BitField grammarErrorFld = new BitField(Integer.MIN_VALUE);
    protected int length;
    protected int mask;
    protected short spellInfo = (short)-1;
    protected short langId = (short)-1;
    protected short altLangId = (short)-1;
    protected short bidi = (short)-1;
    protected int pp10extMask = -1;
    protected byte[] smartTagsBytes = null;

    public TextSpecInfoRun(int len) {
        this.setLength(len);
        this.setLangId((short)0);
    }

    public TextSpecInfoRun(LittleEndianByteArrayInputStream source) {
        this.length = source.readInt();
        this.mask = source.readInt();
        if (spellFld.isSet(this.mask)) {
            this.spellInfo = source.readShort();
        }
        if (langFld.isSet(this.mask)) {
            this.langId = source.readShort();
        }
        if (altLangFld.isSet(this.mask)) {
            this.altLangId = source.readShort();
        }
        if (bidiFld.isSet(this.mask)) {
            this.bidi = source.readShort();
        }
        if (pp10extFld.isSet(this.mask)) {
            this.pp10extMask = source.readInt();
        }
        if (smartTagFld.isSet(this.mask)) {
            int count = source.readInt();
            this.smartTagsBytes = new byte[4 + count * 4];
            LittleEndian.putInt((byte[])this.smartTagsBytes, (int)0, (int)count);
            source.readFully(this.smartTagsBytes, 4, count * 4);
        }
    }

    public void writeOut(OutputStream out) throws IOException {
        byte[] buf = new byte[4];
        LittleEndian.putInt((byte[])buf, (int)0, (int)this.length);
        out.write(buf);
        LittleEndian.putInt((byte[])buf, (int)0, (int)this.mask);
        out.write(buf);
        Object[] flds = new Object[]{spellFld, this.spellInfo, "spell info", langFld, this.langId, "lang id", altLangFld, this.altLangId, "alt lang id", bidiFld, this.bidi, "bidi", pp10extFld, this.pp10extMask, "pp10 extension field", smartTagFld, this.smartTagsBytes, "smart tags"};
        for (int i = 0; i < flds.length; i += 3) {
            boolean valid;
            BitField fld = (BitField)flds[i + 0];
            Object valO = flds[i + 1];
            if (!fld.isSet(this.mask)) continue;
            if (valO instanceof byte[]) {
                byte[] bufB = (byte[])valO;
                valid = bufB.length > 0;
                out.write(bufB);
            } else if (valO instanceof Integer) {
                int valI = (Integer)valO;
                valid = valI != -1;
                LittleEndian.putInt((byte[])buf, (int)0, (int)valI);
                out.write(buf);
            } else if (valO instanceof Short) {
                short valS = (Short)valO;
                valid = valS != -1;
                LittleEndian.putShort((byte[])buf, (int)0, (short)valS);
                out.write(buf, 0, 2);
            } else {
                valid = false;
            }
            if (valid) continue;
            throw new IOException(flds[i + 2] + " is activated, but its value is invalid");
        }
    }

    public SpellInfoEnum getSpellInfo() {
        if (this.spellInfo == -1) {
            return null;
        }
        for (SpellInfoEnum si : new SpellInfoEnum[]{SpellInfoEnum.clean, SpellInfoEnum.error, SpellInfoEnum.grammar}) {
            if (!si.bitField.isSet((int)this.spellInfo)) continue;
            return si;
        }
        return SpellInfoEnum.correct;
    }

    public void setSpellInfo(SpellInfoEnum spellInfo) {
        this.spellInfo = (short)(spellInfo == null ? -1 : (short)spellInfo.bitField.set(0));
        this.mask = spellFld.setBoolean(this.mask, spellInfo != null);
    }

    public short getLangId() {
        return this.langId;
    }

    public void setLangId(short langId) {
        this.langId = langId;
        this.mask = langFld.setBoolean(this.mask, langId != -1);
    }

    public short getAltLangId() {
        return this.altLangId;
    }

    public void setAltLangId(short altLangId) {
        this.altLangId = altLangId;
        this.mask = altLangFld.setBoolean(this.mask, altLangId != -1);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Boolean getBidi() {
        return this.bidi == -1 ? null : Boolean.valueOf(this.bidi != 0);
    }

    public void setBidi(Boolean bidi) {
        this.bidi = (short)(bidi == null ? -1 : (short)(bidi != false ? 1 : 0));
        this.mask = bidiFld.setBoolean(this.mask, bidi != null);
    }

    public byte[] getSmartTagsBytes() {
        return this.smartTagsBytes;
    }

    public void setSmartTagsBytes(byte[] smartTagsBytes) {
        this.smartTagsBytes = smartTagsBytes == null ? null : (byte[])smartTagsBytes.clone();
        this.mask = smartTagFld.setBoolean(this.mask, smartTagsBytes != null);
    }

    public int getPP10RunId() {
        return this.pp10extMask == -1 || !pp10extFld.isSet(this.mask) ? -1 : pp10runidFld.getValue(this.pp10extMask);
    }

    public void setPP10RunId(int pp10RunId) {
        this.pp10extMask = pp10RunId == -1 ? (this.getGrammarError() == null ? -1 : pp10runidFld.clear(this.pp10extMask)) : pp10runidFld.setValue(this.pp10extMask, pp10RunId);
        this.mask = pp10extFld.setBoolean(this.mask, this.pp10extMask != -1);
    }

    public Boolean getGrammarError() {
        return this.pp10extMask == -1 || !pp10extFld.isSet(this.mask) ? null : Boolean.valueOf(grammarErrorFld.isSet(this.pp10extMask));
    }

    public void getGrammarError(Boolean grammarError) {
        this.pp10extMask = grammarError == null ? (this.getPP10RunId() == -1 ? -1 : grammarErrorFld.clear(this.pp10extMask)) : grammarErrorFld.set(this.pp10extMask);
        this.mask = pp10extFld.setBoolean(this.mask, this.pp10extMask != -1);
    }

    public static enum SpellInfoEnum {
        error(new BitField(1)),
        clean(new BitField(2)),
        grammar(new BitField(4)),
        correct(new BitField(0));

        final BitField bitField;

        private SpellInfoEnum(BitField bitField) {
            this.bitField = bitField;
        }
    }
}

